package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by xiaoxuda on 2018/8/1.
 */
public enum GoodsAttrValType {
    NORMAL(1, "普通属性值"),
    TIME_ENUM(2, "时间段枚举"),
    VERSION_ENUM(3, "SAAS版本枚举");

    private Integer code;
    private String desc;

    GoodsAttrValType(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static GoodsAttrValType getByCode(Integer code){
        for(GoodsAttrValType type : values()){
            if(type.getCode().equals(code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
