package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitSimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchSimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlSimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.*;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AttributeLibrarySimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AttributeValueSimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuSimpleDto;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 央视频本地化定制专用remote
 */
@AdvancedFeignClient
public interface RemoteYspLocalGoodsCenterService {
    /**
     * 查找商品规格属性名表
     */
    List<AttributeLibrarySimpleDto> findAttributeLibraryByIds(List<Long> ids);

    /**
     * 保存或更新商品规则属性名表
     */
    void saveOrUpdateAttributeLibrary(AttributeLibrarySimpleDto dto);

    /**
     * 查找商品规格属性表
     */
    List<AttributeValueSimpleDto> findAttributeValueByIds(List<Long> ids);

    /**
     * 保存商品规则属性表
     */
    void saveOrUpdateAttributeValue(AttributeValueSimpleDto dto);

    /**
     * 查找商品分类表
     */
    List<ItemClassifySimpleDto> findItemClassifyByIds(List<Long> ids);

    /**
     * 保存或更新商品分类表
     */
    void saveOrUpdateItemClassify(ItemClassifySimpleDto dto);

    /**
     * 删除商品分类表
     */
    int deleteItemClassifyById(Long id);

    /**
     * 查询兑吧商品表
     */
    List<ItemSimpleDto> findItemByIds(List<Long> ids);

    /**
     * 保存或更新兑吧实物商品
     *
     * @param data
     */
    void saveOrUpdateObjectItem(JSONObject data);

    /**
     * 保存或更新兑吧优惠券或卡密商品
     *
     * @param data
     */
    void saveOrUpdateCouponItem(JSONObject data);

    /**
     * 保存或更新兑吧虚拟商品
     *
     * @param data
     */
    void saveOrUpdateVirtualItem(JSONObject data);

    /**
     * 查询兑吧商品附加属性表
     */
    ItemExtraSimpleDto findItemExtraByItemId(Long itemId);

    /**
     * 查询商品新扩展信息
     */
    List<ItemNewExtraSimpleDto> findItemNewExtraByItemId(Long itemId);

    /**
     * 查询兑吧商品图文配置信息
     */
    ItemDescConfigSimpleDto findItemDescConfigByItemId(Long itemId);

    /**
     * 查询商品地域限制表
     */
    List<AddrLimitSimpleDto> findAddrLimitByItemId(Long itemId);

    /**
     * 查询商品限制
     */
    ItemLimitConfigSimpleDto findItemLimitConfigByItemId(Long itemId);

    /**
     * 查询商品sku
     */
    List<ItemSkuSimpleDto> findItemSkuByItemId(Long itemId);

    /**
     * 查询商品卡券库
     */
    List<CardLibrarySimpleDto> findCardLibraryByItemId(Long itemId);

    /**
     * 查询批次信息
     */
    List<GoodsBatchSimpleDto> findGoodsBatchByCardLibraryIds(List<Long> cardLibraryIds);

    /**
     * 查询商品跳转链接等信息
     */
    TbGoodsOpenUrlSimpleDto findTbGoodsOpenurlByItemId(Long itemId);

    /**
     * 启用或禁用商品
     *
     * @param itemId
     * @param boolEnable
     * @param boolRecoverByDisableLog
     */
    void changeStatus(Long itemId, boolean boolEnable, boolean boolRecoverByDisableLog);

    /**
     * 删除商品
     */
    void deleteItem(Long itemId);

    /**
     * 修改商品位运算符状态
     */
    void updateOperationsType(Long itemId, Integer operatorType, boolean boolOpen);

    /**
     * 查找兑换项的定向关系表
     */
    List<ItemAppSpecifySimpleDto> findItemAppSpecifyByItemId(Long itemId);

    /**
     * 保存或更新定向库存分配信息
     */
    void saveOrUpdateItemAppSpecify(List<ItemAppSpecifySimpleDto> dtos);

    /**
     * 查找商品预分配库存信息
     */
    List<PreStockPointSimpleDto> findPreStockPointByItemId(Long itemId);

    /**
     * 查找商品预分配库存信息
     */
    List<PreStockSimpleDto> findPreStockByByPointIds(List<Long> pointIds);

    /**
     * 保存或更新预库存分配信息
     */
    void saveOrUpdatePreStockPoint(JSONObject data);

    /**
     * 主要是针对链接券和可重复使用券码的批次查询(理论上该批次号下只会有一条数据)
     *
     */
    GoodsCouponSimpleDto findGoodsCouponOneByGidAndBatchId(Long gid, Long batchId);

    /**
     * 查询商品卡券库信息(主要是针对链接券和可重复使用券码)
     */
    List<GoodsCouponSimpleDto> findGoodsCouponByIds(List<Long> ids, Long gid);

    /**
     * 保存或更新卡券库信息(主要是针对链接券和可重复使用券码)
     */
    void saveOrUpdateGoodsCoupon(GoodsCouponSimpleDto dto);

    /**
     * 根据卡券id找到优惠券信息
     */
    GoodsCouponSimpleDto findByGoodsCouponId(Long goodsCouponId);
}
