package cn.com.duiba.goods.center.api.remoteservice.dto.sku;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc SKU规格属性链，树形结构
 * @Author xuwei
 * @Date 2018/11/6
 */
public class SkuAttributeNode<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 4889249887035984312L;

    //属性id
    private String id;
    //图片地址，目前只有根节点有
    private String imgUrl;
    //规格id, 实际是spec id
    private String specId;
    //销售信息（T可能为SKU信息、SKU积分换购信息）
    private T skuInfo;
    //属性名称(比对返回)
    private String attributeValue;
    //规格名称(比对返回)
    private String attributeName;
    //卡密名称(比对返回)
    private String cardLibraryName;

    //子属性列表
    private List<SkuAttributeNode<T>> children;

    public String getCardLibraryName() {
        return cardLibraryName;
    }

    public void setCardLibraryName(String cardLibraryName) {
        this.cardLibraryName = cardLibraryName;
    }

    public String getAttributeValue() {
        return attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getSpecId() {
        return specId;
    }

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public T getSkuInfo() {
        return skuInfo;
    }

    public void setSkuInfo(T skuInfo) {
        this.skuInfo = skuInfo;
    }

    public List<SkuAttributeNode<T>> getChildren() {
        return children;
    }

    public void setChildren(List<SkuAttributeNode<T>> children) {
        this.children = children;
    }

    /**
     * 销售信息
     */
    public static class SkuInfo implements Serializable {

        private static final long serialVersionUID = -9491789203686703L;
        /**
         * skuId，更新时使用
         */
        private String id;
        /**
         * 展示价格
         */
        private String facePrice;

        /**
         * 兑换价格
         */
        private String salePrice;

        //成本价
        private String costPrice;
        /**
         * 商家编码
         */
        private String merchantCoding;

        /**
         * 图片链接（暂时取的是第一个规格属性配置的imgUrl）
         */
        private String imgUrl;

        /**
         * 库存id
         */
        private String stockId;

        /**
         * 剩余库存
         */
        private Integer remaining;

        /**
         * 前一次库存
         */
        private Integer preRemaining;



        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFacePrice() {
            return facePrice;
        }

        public void setFacePrice(String facePrice) {
            this.facePrice = facePrice;
        }

        public String getSalePrice() {
            return salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getMerchantCoding() {
            return merchantCoding;
        }

        public void setMerchantCoding(String merchantCoding) {
            this.merchantCoding = merchantCoding;
        }

        public String getImgUrl() {
            return imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public String getStockId() {
            return stockId;
        }

        public void setStockId(String stockId) {
            this.stockId = stockId;
        }

        public Integer getRemaining() {
            return remaining;
        }

        public void setRemaining(Integer remaining) {
            this.remaining = remaining;
        }

        public Integer getPreRemaining() {
            return preRemaining;
        }

        public void setPreRemaining(Integer preRemaining) {
            this.preRemaining = preRemaining;
        }

        public String getCostPrice() {
            return costPrice;
        }

        public void setCostPrice(String costPrice) {
            this.costPrice = costPrice;
        }
    }

    /**
     * 管理后台销售信息
     */
    public static class SkuSupplyInfo extends SkuInfo{
        private static final long serialVersionUID = 5496247665871114160L;

        /**
         * 建议市场价(仅供管理后台用)
         */
        private String suggestMarketPrice;

        //卡券库id
        private String cardLibraryId;
        // pop商品展示兑换价
        private String popShowPrice;
        // 卡密名称(比对返回)
        private String cardLibraryName;

        public String getCardLibraryName() {
            return cardLibraryName;
        }

        public void setCardLibraryName(String cardLibraryName) {
            this.cardLibraryName = cardLibraryName;
        }

        public String getPopShowPrice() {
            return popShowPrice;
        }

        public void setPopShowPrice(String popShowPrice) {
            this.popShowPrice = popShowPrice;
        }

        public String getSuggestMarketPrice() {
            return suggestMarketPrice;
        }

        public void setSuggestMarketPrice(String suggestMarketPrice) {
            this.suggestMarketPrice = suggestMarketPrice;
        }

        public String getCardLibraryId() {
            return cardLibraryId;
        }

        public void setCardLibraryId(String cardLibraryId) {
            this.cardLibraryId = cardLibraryId;
        }
    }

    /**
     * 开发者管理后台销售信息
     */
    public static class AppItemSkuInfo extends SkuInfo {
        private static final long serialVersionUID = 3929321445588475360L;
        //供货价
        private String supplyPrice;
        //兑吧商品skuId
        private String itemSkuId;
        //卡券库id
        private String cardLibraryId;
        //是否可售
        private Integer saleStatus;
        // 兑吧直播 pop供应价 供应价+供应价*费率
        private String duibaLiveSupplierPrice;
        // 供应商类型 0-自营 1-pop
        private Integer duibaLiveSupplierType;

        // 额外字段
        private String extraJson;

        public Integer getDuibaLiveSupplierType() {
            return duibaLiveSupplierType;
        }

        public void setDuibaLiveSupplierType(Integer duibaLiveSupplierType) {
            this.duibaLiveSupplierType = duibaLiveSupplierType;
        }

        public String getItemSkuId() {
            return itemSkuId;
        }

        public void setItemSkuId(String itemSkuId) {
            this.itemSkuId = itemSkuId;
        }

        public String getCardLibraryId() {
            return cardLibraryId;
        }

        public void setCardLibraryId(String cardLibraryId) {
            this.cardLibraryId = cardLibraryId;
        }

        public String getSupplyPrice() {
            return supplyPrice;
        }

        public void setSupplyPrice(String supplyPrice) {
            this.supplyPrice = supplyPrice;
        }

        public Integer getSaleStatus() {
            return saleStatus;
        }

        public void setSaleStatus(Integer saleStatus) {
            this.saleStatus = saleStatus;
        }

        public String getDuibaLiveSupplierPrice() {
            return duibaLiveSupplierPrice;
        }

        public void setDuibaLiveSupplierPrice(String duibaLiveSupplierPrice) {
            this.duibaLiveSupplierPrice = duibaLiveSupplierPrice;
        }

        public String getExtraJson() {
            return extraJson;
        }

        public void setExtraJson(String extraJson) {
            this.extraJson = extraJson;
        }
    }
}
