package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * appitem extraInfo字段工具类
 * Created by sunyan on 2017/8/18.
 */
public class ExtraInfoUtils {

    public static final String BIZ_CREDITS="bizCredits";
    public static final String BUTTON_TEXT="buttonText";//兑换按钮文字（默认'马上兑换'）
    public static final String LABEL="label";//商品标签
    public static final String SECKILL_PHONE_LIMIT = "seckillLimit"; //是否开启秒杀充值电话号码限制
    //南宁中信，自有商品打标对应哪个供应商
    public static final String SUPPLIER_TAG = "supplierTag";
    //满赠赠品id
    public static final String BONUS_ITEM_ID = "bonusItemId";
    //满赠赠品订单id
    public static final String BONUS_ORDER_ID = "bonusOrderId";
    //农总行商品库，三级类目id
    public static final String CMDY_CATE_LEVEL = "cmdyCateLevel";
    // 汇丰 库存告警邮箱
    public static final String STOCK_WARN_EMAIL = "stockWarnEmailList";
    // 汇丰 库存告警下限
    public static final String STOCK_WARN_LOWER_LIMIT = "stockWarnLowerLimit";
    // 央视频-组件推荐入口开关(false-关闭 true-打开 默认false)
    public static final String RECOMMEND_ENTER_SWITCH = "recommendEnterSwitch";
    // 央视频-组件推荐入口展示文案
    public static final String RECOMMEND_ENTER_TEXT = "recommendEnterText";
    // 央视频-组件推荐入口跳转链接
    public static final String RECOMMEND_ENTER_LINK = "recommendEnterLink";
    // 限制兑换类型 1 限制开启 2 限制开始时间
    public static final String LIMIT_EXCHANGE_TYPE = "limitExchangeType";

    /**
     * 万达定制使用，后续其他app可复用
     */
    public static final String CUSTOM_STRING_ONE = "customStringOne";
    public static final String CUSTOM_STRING_TWO = "customStringTwo";
    public static final String CUSTOM_STRING_THREE= "customStringThree";
    public static final String CUSTOM_STRING_FOUR= "customStringFour";
    public static final String CUSTOM_STRING_FIVE= "customStringFive";
    public static final String CUSTOM_STRING_SIX= "customStringSix";
    public static final String SUPPLIER_IDS = "supplierIds";
    public static final String SUPPLIER_NAME = "supplierName";
    public static final String DIS_NO = "disNo";
    /**
     * 员工标识 0 非员工 1 员工
     */
    public static final String WAND_STAFF = "staff";

    /**
     * 分销酒店，酒店分销才有
     */
    public static final String DiS_GROGGERY = "disGroggery";
    /**
     * 酒店经营管控代码
     */
    public static final String DiS_GROGGERY_BIZ_CODE = "disGroggeryBizCode";

    /**
     * 商品营销活动ID
     */
    public static final String GOODS_ACT_ID = "goodsActId";
    /**
     * 商品营销活动名称
     */
    public static final String GOODS_ACT_NAME = "goodsActName";
    /**
     * 万达供应商ID
     */
    public static final String WANDASUPPLIER_ID = "wandaSupplierId";
    /**
     * 分销员姓名
     */
    public static final String DIS_NAME = "disName";

    /**
     *酒店分销金额（单位：分）
     */
    public static final String DIS_GROGGERY_REWARD = "disGroggeryReward";

    /**
     *
     * 分佣奖励积分值
     */
    public static final String DIS_REWARDS = "disRewards";


    /**
     * 分销比例
     */
    public static final String DISTRIBUTION = "distributionValue";
    /**
     * 关联酒店名称
     */
    public static final String RELEVANCE_NAME = "relevanceName";
    /**
     * 关联酒店code
     */
    public static final String RELEVANCE_CODE = "relevanceCode";

    /**
     * 酒店分佣状态
     */
    public static final String relevance_Giveaway = "relevanceGiveaway";

    /**
     * 酒店分佣比例
     */
    public static final String RELEVANCE_GIVEAWAY_SCALE = "relevanceGiveawayScale";

    /**
     * 分销对象折扣比例
     */
    public static final String DISTRIBUTION_GIVEAWAY_SCALE = "distributionGiveawayScale";
    /**
     * 员工身份
     */
    public static final String DIS_IDENTITY = "disIdentity";

    /**
     * 类目名称
     */
    public final static String WANDA_CATEGORY_NAME = "categoryName";

    /**
     * 专题活动Id
     */
    public final static String WANDA_SUBJECT_ACT_ID = "subjectActId";
    /**
     * 专题活动名称
     */
    public final static String WANDA_SUBJECT_ACT_NAME = "subjectActName";

    /**
     * 员工额外分佣比例
     */
    public final static String WANDA_EMPLOY_EXTRA_DIS_RATE = "employExtraDisRate";

    /**
     * 非员工额外分佣比例
     */
    public final static String WANDA_NO_EMPLOY_EXTRA_DIS_RATE = "noEmployExtraDisRate";
    /**
     * 万达成本价
     */
    public final static String WANDA_COST_PRICE = "wandaCostPrice";
    /**
     * 万达商品售价
     */
    public final static String WAND_SLAE_PRICE = "wandaSalePrice";

    /**
     * 万达支付方式
     */
    public static final String WANDA_PAY_TYPE = "wandaPayType";

    /**
     *万达积分汇率
     */
    public static final String WANDA_CREDITS_RARE= "wandaCreditsRate";

    /**
     * 万达分佣金额
     */
    public static final String WANDA_DISTRIBUTION_AMOUNT = "wandaDisAmount";

    /**
     * 预约商品配置
     * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ReservationGoodsConfig
     */
    public static final String RESERVATION_GOODS_CONFIG = "reservationGoodsConfig";



    private ExtraInfoUtils(){
        //do nothing
    }

    /**
     * 扩展积分
     * @param itemKeyDto
     * @return
     */
    public static String getBizCredits(ItemKeyDto itemKeyDto){
        if (itemKeyDto.getAppItem()!=null) {
            return getBizCredits(itemKeyDto.getAppItem().getExtraInfo());
        }
        return null;
    }

    /**
     * 扩展积分
     * @param extraInfo
     * @return
     */
    public static String getBizCredits(String extraInfo){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(BIZ_CREDITS);
        }
        return null;
    }

    /**
     * 按key获取value
     * @param extraInfo
     * @return
     */
    public static String getValue(String extraInfo,String key){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(key);
        }
        return null;
    }

    /**
     * 商品供应商
     */
    public static Integer getSupplierTag(String extraInfo) {
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getInteger(SUPPLIER_TAG);
        }
        return null;
    }

    /**
     * 库存告警邮件
     * @param extraInfo
     * @return
     */
    public static List<String> getGoodStockWarnEmails(String extraInfo){
        if (StringUtils.isBlank(extraInfo)) {
            return new ArrayList<>();
        }
        return JSONObject.parseObject(extraInfo).getJSONArray(STOCK_WARN_EMAIL).toJavaList(String.class);
    }

    /**
     * 库存告警下限
     * @param extraInfo
     * @return
     */
    public static Integer getGoodStockWarnLowerLimit(String extraInfo){
        if (StringUtils.isBlank(extraInfo)) {
            return null;
        }
        return JSONObject.parseObject(extraInfo).getInteger(STOCK_WARN_LOWER_LIMIT);
    }
}
