package cn.com.duiba.goods.center.api.remoteservice.enums;

public enum LzljCategoryEnum {
    // 枚举常量定义
    CATEGORY_178(178, "酒类", "ZhenXuan"),
    CATEGORY_177(177, "个人护理", "DigitalProducts"),
    CATEGORY_176(176, "家具家纺", "JiaJu"),
    CATEGORY_175(175, "体育用品", "OutDoors"),
    CATEGORY_174(174, "家装建材", "JiaJu"),
    CATEGORY_173(173, "厨具", "JiaJu"),
    CATEGORY_172(172, "IP文创联名", "PeripheralProducts"),
    CATEGORY_169(169, "礼品卡", "VirtualCard"),
    CATEGORY_125(125, "宠物生活", "Others"),
    CATEGORY_124(124, "婚庆节庆", "Others"),
    CATEGORY_122(122, "端午节专区", "Others"),
    CATEGORY_119(119, "母亲节&520专区", "Others"),
    CATEGORY_118(118, "假日专区", "Others"),
    CATEGORY_115(115, "春季踏青", "Others"),
    CATEGORY_73(73, "虚拟卡券", "VirtualCard"),
    CATEGORY_40(40, "个人护理", "DigitalProducts"),
    CATEGORY_36(36, "玩具乐器", "Others"),
    CATEGORY_35(35, "箱包皮具", "BusinessTravel"),
    CATEGORY_33(33, "食品饮料", "food"),
    CATEGORY_32(32, "服饰鞋靴", "Others"),
    CATEGORY_31(31, "母婴用品", "LifeNecessary"),
    CATEGORY_30(30, "户外运动", "SportStore"),
    CATEGORY_29(29, "汽车用品", "QiChe"),
    CATEGORY_28(28, "电脑办公", "DigitalOffice"),
    CATEGORY_27(27, "手机数码", "DigitalOffice"),
    CATEGORY_26(26, "美妆护肤", "Cosmetics"),
    CATEGORY_25(25, "厨房用品", "LifeNecessary"),
    CATEGORY_24(24, "家庭清洁", "LifeNecessary"),
    CATEGORY_23(23, "家用电器", "HouseApp"),
    CATEGORY_22(22, "生活日用", "LifeNecessary");

    // 枚举字段
    private final int id;
    private final String name;
    private final String thirdType;

    // 构造函数
    LzljCategoryEnum(int id, String name, String thirdType) {
        this.id = id;
        this.name = name;
        this.thirdType = thirdType;
    }

    // 获取id
    public int getId() {
        return id;
    }

    // 获取名称
    public String getName() {
        return name;
    }

    // 获取thirdType
    public String getThirdType() {
        return thirdType;
    }

    // 根据id查找对应的枚举
    public static LzljCategoryEnum getById(int id) {
        for (LzljCategoryEnum category : values()) {
            if (category.getId() == id) {
                return category;
            }
        }
        throw new IllegalArgumentException("No enum found for id: " + id);
    }

    // 根据名称查找对应的枚举
    public static LzljCategoryEnum getByName(String name) {
        for (LzljCategoryEnum category : values()) {
            if (category.getName().equals(name)) {
                return category;
            }
        }
        throw new IllegalArgumentException("No enum found for name: " + name);
    }

    // 根据thirdType查找对应的枚举
    public static LzljCategoryEnum getByThirdType(String thirdType) {
        for (LzljCategoryEnum category : values()) {
            if (category.getThirdType().equals(thirdType)) {
                return category;
            }
        }
        throw new IllegalArgumentException("No enum found for thirdType: " + thirdType);
    }
}