package cn.com.duiba.goods.center.api.remoteservice.dto;

import cn.com.duiba.goods.center.api.remoteservice.enums.VersionPlanEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 旺店通供应商API配置DTO
 * 
 * @author cgq
 * @date 2024-12-19
 */
@Data
public class WdtSupplierApiConfigDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 版本套餐：1-企业版，2-旗舰版
     * @see VersionPlanEnum
     */
    private Integer versionPlan;

    /**
     * 卖家账号
     */
    private String sellerAccount;

    /**
     * 接口账号
     */
    private String apiAccount;

    /**
     * appsecret
     */
    private String appSecret;

    /**
     * 盐值（旗舰版使用）
     */
    private String salt;

    /**
     * 店铺编号
     */
    private String shopNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
