package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Desc 开发者商品查询参数
 */
public class AppItemQueries implements Serializable {
    private Long appId;
    //类型
    private String type;
    //子类型
    private Integer subType;
    //类型列表
    private List<String> types;
    //分组id
    private Long classifyId;
    //是否支持原价购买 ture：支持  false：不支持
    private Boolean originalPriceBuy;
    //是否自有  true：自有 false：分销
    private Boolean isOwner;
    //状态
    private String status;
    //商品名称
    private String title;
    //商品id列表
    private List<Long> ids;
    //过滤秒杀商品
    private Boolean exceptSeckill;
    //是否多规格 ture：多规格 false：无规格
    private Boolean multiSku;
    //运费类型 AppItemDto.ExpressTypeFree, AppItemDto.ExpressTypeUnity, AppItemDto.ExpressTypeTemplate
    private String expressType;
    //是否会员商品
    private Boolean vipGoods;
    //是否过滤老版本商品
    private Boolean filterOldVersion;
    //是否置顶商品优先显示
    private boolean topFirst;
    //是否去除供应商商品 true 去除 null或者false 不去除
    private Boolean exclusiveDistributor;
    //是否定向商品
    private Boolean direct;

    //有效期状态(已过期expired，即将过期unexpire，已失效invalid)
    private String expiredStatus;
    //是否查询自动上架商品
    private Boolean queryAutoOn;

    /**
     * 创建日期开始
     */
    private Date gmtCreateStart;

    /**
     * 创建日期结束
     */
    private Date gmtCreateEnd;

    /**
     * skuMerchantCode
     */
    private String appSkuMerchantCoding;

    /**
     * 万达定制：商品标签 1员工，2分销  WandaGoodsTagEnum
     */
    private String wandaGoodsTag;

    /**
     * 万达定制：商品活动id
     */
    private Long goodsActId;

    public String getWandaGoodsTag() {
        return wandaGoodsTag;
    }

    public void setWandaGoodsTag(String wandaGoodsTag) {
        this.wandaGoodsTag = wandaGoodsTag;
    }

    public String getAppSkuMerchantCoding() {
        return appSkuMerchantCoding;
    }

    public void setAppSkuMerchantCoding(String appSkuMerchantCoding) {
        this.appSkuMerchantCoding = appSkuMerchantCoding;
    }

    public Boolean getDirect() {
        return direct;
    }

    public void setDirect(Boolean direct) {
        this.direct = direct;
    }

    public Boolean getQueryAutoOn() {
        return queryAutoOn;
    }

    public void setQueryAutoOn(Boolean queryAutoOn) {
        this.queryAutoOn = queryAutoOn;
    }

    public Boolean getExclusiveDistributor() {
        return exclusiveDistributor;
    }

    public void setExclusiveDistributor(Boolean exclusiveDistributor) {
        this.exclusiveDistributor = exclusiveDistributor;
    }

    public String getExpiredStatus() {
        return expiredStatus;
    }

    public void setExpiredStatus(String expiredStatus) {
        this.expiredStatus = expiredStatus;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = StringUtils.isBlank(type) ? null : type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<String> getTypes() {
        return types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Boolean getOriginalPriceBuy() {
        return originalPriceBuy;
    }

    public void setOriginalPriceBuy(Boolean originalPriceBuy) {
        this.originalPriceBuy = originalPriceBuy;
    }

    public Boolean getIsOwner() {
        return isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = StringUtils.isBlank(status) ? null : status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = StringUtils.isBlank(title) ? null : title;
    }

    public List<Long> getIds() {
        return CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = CollectionUtils.isEmpty(ids) ? null : ids;
    }

    public Boolean getExceptSeckill() {
        return exceptSeckill;
    }

    public void setExceptSeckill(Boolean exceptSeckill) {
        this.exceptSeckill = exceptSeckill;
    }

    public Boolean getMultiSku() {
        return multiSku;
    }

    public void setMultiSku(Boolean multiSku) {
        this.multiSku = multiSku;
    }

    public String getExpressType() {
        return expressType;
    }

    public void setExpressType(String expressType) {
        this.expressType = StringUtils.isBlank(expressType) ? null : expressType;
    }

    public Boolean getVipGoods() {
        return vipGoods;
    }

    public void setVipGoods(Boolean vipGoods) {
        this.vipGoods = vipGoods;
    }

    public Boolean getFilterOldVersion() {
        return filterOldVersion;
    }

    public void setFilterOldVersion(Boolean filterOldVersion) {
        this.filterOldVersion = filterOldVersion;
    }

    public boolean getTopFirst() {
        return topFirst;
    }

    public void setTopFirst(boolean topFirst) {
        this.topFirst = topFirst;
    }

    /**
     * 是否需要过滤置顶商品
     * 分组内置顶商品 和 普通置顶商品 是业务隔离的，不互相影响
     *
     * @return
     */
    public boolean getFilterTop() {
        return topFirst && classifyId == null;
    }

    public Boolean getOwner() {
        return isOwner;
    }

    public void setOwner(Boolean owner) {
        isOwner = owner;
    }

    public boolean isTopFirst() {
        return topFirst;
    }

    public Date getGmtCreateStart() {
        return gmtCreateStart;
    }

    public void setGmtCreateStart(Date gmtCreateStart) {
        this.gmtCreateStart = gmtCreateStart;
    }

    public Date getGmtCreateEnd() {
        return gmtCreateEnd;
    }

    public void setGmtCreateEnd(Date gmtCreateEnd) {
        this.gmtCreateEnd = gmtCreateEnd;
    }

    public Long getGoodsActId() {
        return goodsActId;
    }

    public void setGoodsActId(Long goodsActId) {
        this.goodsActId = goodsActId;
    }
}
