package cn.com.duiba.goods.center.api.remoteservice.dto.jbp;

import java.io.Serializable;

/**
 * C端扣库存结果DTO
 * 
 * @author zhangdaqing
 * @Description C端扣库存操作的结果，包含扣减的库存key、库存值和版本号
 */
public class CStockDecrementResultDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 扣减的库存key对应的jbpStockRecordId（在传入列表中的索引，从1开始）
     */
    private Integer usedKeyIndex;

    /**
     * 扣减的jbpStockRecordId
     */
    private Long jbpStockRecordId;

    /**
     * 新的库存值
     */
    private Long stock;

    /**
     * 新的版本号
     */
    private Long version;

    /**
     * 错误信息
     */
    private String errorMessage;

    public CStockDecrementResultDto() {
    }

    public CStockDecrementResultDto(boolean success, Integer usedKeyIndex, Long jbpStockRecordId, Long stock, Long version) {
        this.success = success;
        this.usedKeyIndex = usedKeyIndex;
        this.jbpStockRecordId = jbpStockRecordId;
        this.stock = stock;
        this.version = version;
    }

    public CStockDecrementResultDto(boolean success, String errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Integer getUsedKeyIndex() {
        return usedKeyIndex;
    }

    public void setUsedKeyIndex(Integer usedKeyIndex) {
        this.usedKeyIndex = usedKeyIndex;
    }

    public Long getJbpStockRecordId() {
        return jbpStockRecordId;
    }

    public void setJbpStockRecordId(Long jbpStockRecordId) {
        this.jbpStockRecordId = jbpStockRecordId;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

