package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * Created by xiaoxuda on 2017/4/7.
 */
public enum GoodsCouponStatusEnum {
    STATUS_NEW(0, "未发放"),
    STATUS_LOCK(1, "已锁定"),
    STATUS_USED(2, "已使用");

    private Integer code;
    private String desc;

    GoodsCouponStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static GoodsCouponStatusEnum getByCode(Integer code){
        for(GoodsCouponStatusEnum statusEnum:values()){
            if(statusEnum.getCode().equals(code)){
                return statusEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
