/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsCouponService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.front
 * Date:2016年5月24日下午4:19:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.api.remoteservice.front;

import cn.com.duiba.api.enums.GoodsTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * ClassName:RemoteGoodsCouponService <br/>
 * Function: 前台服务，提供发券和还券操作 <br/>
 * Date:     2016年5月24日 下午4:19:45 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteGoodsCouponService {
	
    /**
     * 确认完成一张券(在订单最终成功时来调用此方法)
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param orderId 订单id
     * @return 是否成功
     * @since JDK 1.6
     */
    public DubboResult<Boolean> completeCoupon(Long couponId,long orderId);
    /**
     * 回滚一张券<br/>
     * 如果先锁定一张券，最终订单失败了，需要调用此方法，将券回滚为 未使用  状态
     *
     * @author xuhengfei
     * @param couponId 券号
     * @param bizNum 业务编号
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum);

    /**
     * 根据券码ID查询券码DTO
     * @author houwen
     * @param gtype GTYPE
     * @param gid GID
     * @param couponId 券码ID
     * @return
     */
    @Deprecated
    @RequestMapping("findCouponByIdAndType")
    public DubboResult<GoodsCouponDto> findCoupon(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype,long gid, Long couponId);

	/**
	 * 根据券码ID查询券码DTO
	 * @author houwen
	 * @param gtype GTYPE
	 * @param gid GID
	 * @param couponId 券码ID
	 * @return
	 */
	public DubboResult<GoodsCouponDto> findCouponApi(GoodsTypeEnum gtype,long gid, Long couponId);
    
    /**
     * 查询当前使用中的批次信息（前台用户展示过期开始结束时间）
     * @param gtype
     * @param gid
     * @return
     */
    @Deprecated
    public DubboResult<GoodsBatchDto> findUsingBatch(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype,long gid);

	/**
	 * 查询当前使用中的批次信息（前台用户展示过期开始结束时间）
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<GoodsBatchDto> findUsingBatchApi(GoodsTypeEnum gtype,long gid);
    
    /**
     * 查询商品当前批次库存
     * @author houwen
     * @param gtype
     * @param gid
     * @return
     */
    @Deprecated
    public DubboResult<Long> findGoodsStock(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype,long gid);

	/**
	 * 查询商品当前批次库存
	 * @author houwen
	 * @param gtype
	 * @param gid
	 * @return
	 */
	public DubboResult<Long> findGoodsStockApi(GoodsTypeEnum gtype,long gid);
    
    /**
     * 批量查询商品当前批次库存
     * @author houwen
     * @param goods
     * @return
     */
    @Deprecated
    public DubboResult<List<GoodsStockDto>> findGoodsStockByBatch(List<GoodsStockDto> goods);

	/**
	 * 批量查询商品当前批次库存
	 * @author houwen
	 * @param goods
	 * @return
	 */
	public DubboResult<List<GoodsStockApiDto>> findGoodsStockByBatchApi(List<GoodsStockApiDto> goods);

    /**
     * @deprecated
     * 查询一张券信息
     *
     * @author xuhengfei
     * @param couponId 券号
     * @return 券信息
     * @since JDK 1.6
     */
    @Deprecated
    public GoodsCouponDto findCoupon(long couponId);
    

    /**
     * 查询一张券码
     * @param couponId
     * @return
     */
    public DubboResult<GoodsCouponDto> findCouponById(Long couponId);
    
    /**
	 * 领一张券
	 * 
	 * @param gtype 商品类型
	 * @param gid 商品id
	 * @param consumerId 用户id
	 * @param appId 应用ID
	 * @param bizNum 业务编号
	 * @return
	 */
    @Deprecated
	public DubboResult<GoodsCouponDto> takeCoupon(cn.com.duiba.dcommons.enums.GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum);

	/**
	 * 领一张券
	 *
	 * @param gtype 商品类型
	 * @param gid 商品id
	 * @param consumerId 用户id
	 * @param appId 应用ID
	 * @param bizNum 业务编号
	 * @return
	 */
	public DubboResult<GoodsCouponDto> takeCouponApi(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum);


	public List<GoodsCouponDto> findCouponListByIds(List<Long> couponIds);
}

