package cn.com.duiba.goods.center.api.remoteservice.marketing;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.marketing.MarketingItemCreditsDto;

/**
 * @Desc 商品积分换购配置service
 * @Author xuwei
 * @Date 2018/11/6
 */
@AdvancedFeignClient
public interface RemoteMarketingItemCreditsService {
    /**
     * 根据自有商品id查询
     *
     * @param appItemId
     * @return
     */
    MarketingItemCreditsDto findByAppItemId(Long appItemId);

    /**
     * 插入
     *
     * @param marketingItemCreditsDto
     * @return
     */
    Long insert(MarketingItemCreditsDto marketingItemCreditsDto) throws BizException;

    /**
     * 更新
     *
     * @param marketingItemCreditsDto
     * @return
     */
    void update(MarketingItemCreditsDto marketingItemCreditsDto) throws BizException;

    /**
     * 更新最小价格和积分
     *
     * @param appItemId
     * @param credits
     * @param price
     * @return
     */
    void updateCreditsAndPriceByAppItemId(Long appItemId, Long credits, Long price) throws BizException;
}
