package cn.com.duiba.goods.center.api.remoteservice.marketing;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.marketing.MarketingItemCreditsSkuDto;

import java.util.List;

/**
 * @Desc 商品SKU积分换购配置service
 * @Author xuwei
 * @Date 2018/11/6
 */
@AdvancedFeignClient
public interface RemoteMarketingItemCreditsSkuService {
    /**
     * 根据自有商品id查询
     *
     * @param itemCreditsId
     * @return
     */
    List<MarketingItemCreditsSkuDto> findByItemCreditsId(Long itemCreditsId);

    /**
     * 更新
     *
     * @param records
     * @return
     */
    Integer batchUpdateByItemCreditsId(Long itemCreditsId, List<MarketingItemCreditsSkuDto> records) throws BizException;

    /**
     * 根据sku id查询
     *
     * @param skuId
     * @return
     */
    MarketingItemCreditsSkuDto findBySkuId(Long skuId);
}
