package cn.com.duiba.goods.center.api.remoteservice.tool;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @Desc 单位转换工具
 * @Author xuwei
 * @Date 2018/11/12
 */
public class UnitUtils {
    //元-分单位转换常量
    private static final BigDecimal B100 = new BigDecimal(100);

    /**
     * 元 -> 分转换
     *
     * @param price
     * @return
     */
    public static Long transformYuan2Fen(String price) {
        if (StringUtils.isBlank(price)) {
            return null;
        }
        return B100.multiply(new BigDecimal(price.trim())).longValue();
    }

    /**
     * 分 -> 元转换
     *
     * @param price
     * @return
     */
    public static String transformFen2Yuan(Long price) {
        if (price == null) {
            return null;
        }
        return new BigDecimal(price).divide(B100, 2, RoundingMode.HALF_UP).toString();
    }

    /**
     * 分 -> 元转换
     *
     * @param price
     * @return
     */
    public static String transformFen2Yuan(Integer price) {
        if (price == null) {
            return null;
        }
        return new BigDecimal(price).divide(B100, 2, RoundingMode.HALF_UP).toString();
    }
}
