/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.util;

import cn.com.duiba.api.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponQueryParamDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsApiDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class GoodsDtoTransferUtils {
    private GoodsDtoTransferUtils() {
    }

    public static GoodsStockApiDto stockToApi(GoodsStockDto stock) {
        GoodsStockApiDto stockApi = (GoodsStockApiDto)BeanUtils.copy((Object)stock, GoodsStockApiDto.class);
        if (null != stock && null != stock.getGtype()) {
            stockApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum((int)stock.getGtype().getGtype()));
        }
        return stockApi;
    }

    public static GoodsStockDto apiToStock(GoodsStockApiDto stockApi) {
        GoodsStockDto stock = (GoodsStockDto)BeanUtils.copy((Object)stockApi, GoodsStockDto.class);
        if (null != stockApi && null != stockApi.getGtype()) {
            stock.setGtype(cn.com.duiba.dcommons.enums.GoodsTypeEnum.getGoodsTypeEnum((int)stockApi.getGtype().getGtype()));
        }
        return stock;
    }

    public static GoodsDirectionalConfigApiDto configToApi(GoodsDirectionalConfigDto config) {
        GoodsDirectionalConfigApiDto configApi = (GoodsDirectionalConfigApiDto)BeanUtils.copy((Object)config, GoodsDirectionalConfigApiDto.class);
        if (null != config && null != config.getGtype()) {
            configApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum((int)config.getGtype().getGtype()));
        }
        return configApi;
    }

    public static GoodsDirectionalConfigDto apiToConfig(GoodsDirectionalConfigApiDto configApi) {
        GoodsDirectionalConfigDto config = (GoodsDirectionalConfigDto)BeanUtils.copy((Object)configApi, GoodsDirectionalConfigDto.class);
        if (null != configApi && null != configApi.getGtype()) {
            config.setGtype(cn.com.duiba.dcommons.enums.GoodsTypeEnum.getGoodsTypeEnum((int)configApi.getGtype().getGtype()));
        }
        return config;
    }

    public static GoodsCouponQueryParamApiDto paramToApi(GoodsCouponQueryParamDto param) {
        GoodsCouponQueryParamApiDto paramApi = (GoodsCouponQueryParamApiDto)BeanUtils.copy((Object)param, GoodsCouponQueryParamApiDto.class);
        if (null != param && null != param.getGtype()) {
            paramApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum((int)param.getGtype().getGtype()));
        }
        return paramApi;
    }

    public static ChangeACGTypeApiDto typeToApi(ChangeACGTypeDto type) {
        ChangeACGTypeApiDto typeApi = (ChangeACGTypeApiDto)BeanUtils.copy((Object)type, ChangeACGTypeApiDto.class);
        if (null != type && null != type.getGtype()) {
            typeApi.setGtype(GoodsTypeEnum.getGoodsTypeEnum((int)type.getGtype().getGtype()));
        }
        return typeApi;
    }

    public static PCGCategorySellerGoodsDto apiToSellerGoods(PCGCategorySellerGoodsApiDto sellerGoodsApi) {
        PCGCategorySellerGoodsDto sellerGoods = (PCGCategorySellerGoodsDto)BeanUtils.copy((Object)sellerGoodsApi, PCGCategorySellerGoodsDto.class);
        if (null != sellerGoodsApi) {
            sellerGoods.setImageJson(sellerGoodsApi.getImageJson());
            sellerGoods.setBannerImgNew(sellerGoodsApi.getBannerImgNew());
            sellerGoods.setSmallImgNew(sellerGoodsApi.getSmallImgNew());
            if (null != sellerGoodsApi.getGoodsDirectionalConfigApiDto()) {
                sellerGoods.setGoodsDirectionalConfigDto(GoodsDtoTransferUtils.apiToConfig(sellerGoodsApi.getGoodsDirectionalConfigApiDto()));
            }
        }
        return sellerGoods;
    }

    public static Page<PCGCategorySellerGoodsDto> apiToSellerGoodsPage(Page<PCGCategorySellerGoodsApiDto> pageApi) {
        if (null == pageApi) {
            return null;
        }
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageApi.getPageSize(), pageApi.getCurrent());
        page.setTotalCount(pageApi.getTotalCount());
        page.setTotalPages(pageApi.getTotalPages());
        if (CollectionUtils.isNotEmpty(pageApi.getList())) {
            page.setList(pageApi.getList().stream().map(x -> GoodsDtoTransferUtils.apiToSellerGoods(x)).collect(Collectors.toList()));
        }
        return page;
    }
}

