/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponBO")
public class GoodsCouponBOImpl
implements GoodsCouponBO {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponBOImpl.class);
    @Autowired
    @Qualifier(value="goodsCouponService4Speed")
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteStockService remoteStockService;
    private LoadingCache<Long, Lock> lockmap = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, Lock>(){

        public Lock load(Long key) throws Exception {
            return new ReentrantLock();
        }
    });

    @Override
    public GoodsCouponEntity takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId, String bizNum) {
        boolean saleout;
        GoodsBatchEntity using = this.goodsBatchService.getUsingBatch(gtype, gid);
        if (using == null && !(saleout = this.fastCheckSaleout(gtype, gid)) && (using = this.retryLockRefreshBatchUsing(gtype, gid)) == null) {
            return null;
        }
        return this.getCouponInCycle(using, consumerId, bizNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsCouponEntity getCouponInCycle(GoodsBatchEntity using, long consumerId, String bizNum) {
        GoodsTypeEnum gtype = GoodsTypeEnum.getGoodsTypeEnum((int)using.getGtype());
        long gid = using.getGid();
        try {
            DBTimeProfile.enter((String)"GoodsCouponBOImpl.getCouponInCycle invoke takeXXX");
            if (using.getBatchType() == 1) {
                GoodsCouponEntity goodsCouponEntity = this.goodsCouponService.takeLinkCoupon(gtype, using, consumerId, bizNum);
                return goodsCouponEntity;
            }
            if (using.getBatchType() == 2) {
                GoodsCouponEntity goodsCouponEntity = this.goodsCouponService.takeRepeatCoupon(gtype, using, consumerId, bizNum);
                return goodsCouponEntity;
            }
            if (using.getBatchType() == 0) {
                GoodsCouponEntity goodsCouponEntity = this.goodsCouponService.takeNormalCoupon(gtype, using, consumerId);
                return goodsCouponEntity;
            }
            GoodsCouponEntity goodsCouponEntity = null;
            return goodsCouponEntity;
        }
        catch (RuntimeGoodsException e) {
            if (e.getErrorCode() == ErrorCode.E0202005) {
                GoodsBatchEntity batch = this.retryLockRefreshBatchUsing(gtype, gid);
                if (batch != null) {
                    GoodsCouponEntity goodsCouponEntity = this.getCouponInCycle(batch, consumerId, bizNum);
                    return goodsCouponEntity;
                }
                throw new RuntimeGoodsException(ErrorCode.E0202006);
            }
            log.error("takeOneCouponInBatch error gtype=" + gtype.getGtype() + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)e);
            GoodsCouponEntity goodsCouponEntity = null;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private GoodsBatchEntity retryLockRefreshBatchUsing(GoodsTypeEnum gtype, long gid) {
        Lock lock = (Lock)this.lockmap.getUnchecked((Object)gid);
        if (lock != null && lock.tryLock()) {
            return this.forceGetUsingBatch(gtype, gid);
        }
        return null;
    }

    private boolean fastCheckSaleout(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
        boolean saleout = true;
        for (GoodsBatchEntity e : batchs) {
            if (e.getStatus() != 1 && e.getStatus() != 2) continue;
            saleout = false;
            break;
        }
        return saleout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsBatchEntity forceGetUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)(this.getClass().getSimpleName() + ".forceGetUsingBatch"));
            List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity e : batchs) {
                long stock = this.goodsCouponService.findNotUsedCount(e);
                if (stock > 0L) continue;
                this.goodsBatchService.markBatchStatusUsed(e.getId());
            }
            batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 1) continue;
                backups.add(e);
                if (min == null) {
                    min = e.getStartDay();
                    continue;
                }
                if (min.getTime() <= e.getStartDay().getTime()) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.goodsBatchService.markBatchStatusUsing(e.getId());
                GoodsBatchEntity goodsBatchEntity = this.goodsBatchService.find(e.getId());
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponService.completeCoupon(couponId, orderId);
    }

    @Override
    public Boolean rollbackCoupon(Long couponId, String bizNum) {
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long goodsBatchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(goodsBatchId);
        if (batch.getBatchType() == 1 || batch.getBatchType() == 2) {
            DubboResult stockRet = this.remoteStockService.increaseItemStock(batch.getId().longValue(), bizNum);
            if (stockRet.isSuccess() && ((Boolean)stockRet.getResult()).booleanValue()) {
                return true;
            }
        } else if (batch.getBatchType() == 0) {
            return this.goodsCouponService.rollbackNormalCoupon(couponId);
        }
        return false;
    }
}

