/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCouponTakeWorker {
    RedisTemplate<String, String> redisTemplate;
    private RedisTemplate<String, GoodsCouponEntity> redisTemplateCoupons;

    private boolean tryLockBatch(Long goodsBatchId) {
        Long value = this.redisTemplate.opsForValue().increment((Object)this.getBatchLockKey(goodsBatchId), 1L);
        if (value == 1L) {
            this.redisTemplate.expire((Object)this.getBatchLockKey(goodsBatchId), 30L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    private void unlockBatch(Long goodsBatchId) {
        this.redisTemplate.delete((Object)this.getBatchLockKey(goodsBatchId));
    }

    private String getBatchLockKey(Long goodsBatchId) {
        return "xxx-" + goodsBatchId;
    }

    private String getBatchContentKey(Long goodsBatchId) {
        return "xxxxxx-" + goodsBatchId;
    }

    public GoodsCouponEntity takeOneCouponInBatch(GoodsTypeEnum gtype, long gid, long consumerId, long goodsBatchId) throws Exception {
        this.redisTemplateCoupons.opsForSet().size((Object)this.getBatchContentKey(goodsBatchId));
        GoodsCouponEntity entity = (GoodsCouponEntity)this.redisTemplateCoupons.opsForSet().pop((Object)this.getBatchContentKey(goodsBatchId));
        return null;
    }
}

