/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="goodsBatchDao")
public class GoodsBatchDaoImpl
extends BaseDao
implements GoodsBatchDao {
    private Logger log = LoggerFactory.getLogger(GoodsBatchDaoImpl.class);

    @Override
    public Long insert(GoodsTypeEnum gtype, Long gid, CouponType batchType, Date startDay, Date endDay) {
        GoodsBatchEntity entity = new GoodsBatchEntity();
        entity.setGtype(gtype.getGtype());
        entity.setGid(gid);
        entity.setBatchType(batchType.getValue());
        entity.setStartDay(startDay);
        entity.setEndDay(endDay);
        entity.setStatus(1);
        entity.setImporting(false);
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)entity);
        return entity.getId();
    }

    @Override
    public GoodsBatchEntity select(Long id) {
        return (GoodsBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("select"), (Object)id);
    }

    @Override
    public List<GoodsBatchEntity> selectNotDeletedByGtypeGid(GoodsTypeEnum gtype, long gid) {
        Map<String, Object> params = this.getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectNotDeletedByGtypeGid"), params);
    }

    @Override
    public List<GoodsBatchEntity> selectNotDeletedNotExpiredGtypeGid(GoodsTypeEnum gtype, long gid) {
        Map<String, Object> params = this.getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectNotDeletedNotExpiredGtypeGid"), params);
    }

    @Override
    public void updateImportingYes(Long id) {
        this.getSqlSession().update(this.getStamentNameSpace("updateImportingYes"), (Object)id);
    }

    @Override
    public void updateImportingNo(Long id) {
        this.getSqlSession().update(this.getStamentNameSpace("updateImportingNo"), (Object)id);
    }

    @Override
    public int deleteBatch(GoodsTypeEnum gtype, long gid, Long goodsBatchId) {
        Map<String, Object> params = this.getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return this.getSqlSession().update(this.getStamentNameSpace("deleteBatch"), params);
    }

    @Override
    public int updateStockId(GoodsTypeEnum gtype, long gid, Long goodsBatchId, Long stockId) {
        Map<String, Object> params = this.getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("stockId", stockId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStockId"), params);
    }

    @Override
    public int updateStatusUsed(Long id) {
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusUsed"), (Object)id);
    }

    @Override
    public int updateStatusUsing(Long id) {
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusUsing"), (Object)id);
    }

    @Override
    public int updateStatusNotUsed(Long id) {
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusNotUsed"), (Object)id);
    }
}

