/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGCategoryBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGCategoryBackendService")
public class RemotePCGCategoryBackendServiceImpl
implements RemotePCGCategoryBackendService {
    private static Logger log = LoggerFactory.getLogger(RemotePCGCategoryBackendServiceImpl.class);
    @Autowired
    private PCGCategoryGoodsService pcgCategoryGoodsService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;

    public DubboResult<Long> createCategory(String name) {
        try {
            Long id = this.pcgCategoryGoodsService.addCategory(name);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("createCategory name=" + name, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteCategory(Long categoryId) {
        try {
            if (this.pcgCategoryGoodsService.removeCategory(categoryId).booleanValue()) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"");
        }
        catch (Exception e) {
            log.error("deleteCategory categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGCategoryDto>> findAll() {
        try {
            ArrayList<PCGCategoryDto> ret = new ArrayList<PCGCategoryDto>();
            List<PCGCategoryEntity> list = this.pcgCategoryGoodsService.findAll();
            for (PCGCategoryEntity e : list) {
                PCGCategoryDto dto = new PCGCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setPayload(e.getPayload());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGCategoryGoodsDto>> findAllByCategoryId(long categoryId) {
        try {
            ArrayList<PCGCategoryGoodsDto> ret = new ArrayList<PCGCategoryGoodsDto>();
            List<PCGCategoryGoodsEntity> list = this.pcgCategoryGoodsService.findAllGoodsByCategory(categoryId);
            ArrayList<Long> pcgIds = new ArrayList<Long>();
            for (PCGCategoryGoodsEntity e : list) {
                PCGCategoryGoodsDto dto = new PCGCategoryGoodsDto();
                dto.setId(e.getId());
                dto.setCategoryId(e.getCategoryId());
                dto.setPayload(e.getPayload());
                dto.setPcgId(e.getPcgId());
                ret.add(dto);
                pcgIds.add(e.getPcgId());
            }
            if (!pcgIds.isEmpty()) {
                Map<Long, PlatformCouponGoodsEntity> map = this.platformCouponGoodsService.findByIds(pcgIds);
                for (PCGCategoryGoodsDto dto : ret) {
                    dto.setTitle(map.get(dto.getPcgId()).getTitle());
                }
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAllByCategoryId categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortCategories(List<PCGCategoryDto> categories) {
        try {
            this.pcgCategoryGoodsService.sortCategories(categories);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("sortCategories", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortCategoryGoods(List<PCGCategoryGoodsDto> list) {
        try {
            this.pcgCategoryGoodsService.sortCategoryGoods(list);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("sortCategoryGoods", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editCategoryName(long categoryId, String name) {
        try {
            this.pcgCategoryGoodsService.updateCategoryName(categoryId, name);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("sortCategoryGoods categoryId=" + categoryId + ",name=" + name, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> addGoods(long categoryId, long pcgId) {
        try {
            boolean ret = this.pcgCategoryGoodsService.addGoods2Category(pcgId, categoryId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRelation categoryId=" + categoryId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteGoods(long categoryId, long pcgId) {
        try {
            boolean ret = this.pcgCategoryGoodsService.removeGoodsFromCategory(pcgId, categoryId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("deleteRelation categoryId=" + categoryId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

