/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGFilterConfigBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGFilterConfigBackendService")
public class RemotePCGFilterConfigBackendServiceImpl
implements RemotePCGFilterConfigBackendService {
    private static Logger log = LoggerFactory.getLogger(RemotePCGFilterConfigBackendServiceImpl.class);
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;

    public DubboResult<Long> addCategoryBlackList(Long appId, Long categoryId) {
        try {
            Long l = this.pCGFilterConfigService.insert(appId, 2, categoryId);
            return DubboResult.successResult((Object)l);
        }
        catch (Exception e) {
            log.error("addCategoryBlackList appId=" + appId + ",categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteCategoryBlackList(Long appId, Long categoryId) {
        try {
            this.pCGFilterConfigService.delete(appId, 2, categoryId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("deleteCategoryBlackList appId=" + appId + ",categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> addSellerBlackList(Long appId, Long sellerId) {
        try {
            Long l = this.pCGFilterConfigService.insert(appId, 3, sellerId);
            return DubboResult.successResult((Object)l);
        }
        catch (Exception e) {
            log.error("addSellerBlackList appId=" + appId + ",sellerId=" + sellerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteSellerBlackList(Long appId, Long sellerId) {
        try {
            this.pCGFilterConfigService.delete(appId, 3, sellerId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("deleteSellerBlackList appId=" + appId + ",sellerId=" + sellerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> addGoodsBlackList(Long appId, Long pcgId) {
        try {
            Long l = this.pCGFilterConfigService.insert(appId, 1, pcgId);
            return DubboResult.successResult((Object)l);
        }
        catch (Exception e) {
            log.error("addGoodsBlackList appId=" + appId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteGoodsBlackList(Long appId, Long pcgId) {
        try {
            this.pCGFilterConfigService.delete(appId, 1, pcgId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("deleteGoodsBlackList appId=" + appId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGDto>> findGoodsFilterList(Long appId) {
        try {
            ArrayList list = new ArrayList();
            ObjectUtil.convertList(this.pCGFilterConfigService.findGoodsFilterList(appId), list, PCGDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findGoodsFilterList appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGCategoryDto>> findCategoryFilterList(Long appId) {
        try {
            ArrayList list = new ArrayList();
            ObjectUtil.convertList(this.pCGFilterConfigService.findCategoryFilterList(appId), list, PCGCategoryDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findCategoryFilterList appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGSellerDto>> findSellerFilterList(Long appId) {
        try {
            ArrayList list = new ArrayList();
            ObjectUtil.convertList(this.pCGFilterConfigService.findSellerFilterList(appId), list, PCGSellerDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findSellerFilterList appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGFilterConfigDto>> findCounponBelong(Long goodsId) {
        try {
            ArrayList list = new ArrayList();
            ObjectUtil.convertList(this.pCGFilterConfigService.findCounponBelong(goodsId), list, PCGFilterConfigDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findCounponBelong goodsId=" + goodsId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<PCGDto>> findPCGCategroySellerGoodsList(Long appId, int pageSize, int pageIndex) {
        try {
            ArrayList list = new ArrayList();
            Page<PlatformCouponGoodsEntity> pagelist = this.pCGFilterConfigService.selectPCGCategroySellerGoodsList(appId, pageSize, pageIndex);
            List platformCouponGoodsEntitylist = pagelist.getList();
            ObjectUtil.convertList((List)platformCouponGoodsEntitylist, list, PCGDto.class);
            Page ret = new Page(pageSize, pageIndex);
            ret.setTotalCount(pagelist.getTotalCount());
            ret.setTotalPages(pagelist.getTotalPages());
            ret.setList(list);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("findPCGCategroySellerGoodsList appId=" + appId + ",pageSize=" + pageSize + ",pageIndex=" + pageIndex, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId, Integer type) {
        try {
            List<Long> list = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, type);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findPCGCategroySellerGoodsList appId=" + appId + ",type=" + type, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

