/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGSellerBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGSellerBackendService")
public class RemotePCGSellerBackendServiceImpl
implements RemotePCGSellerBackendService {
    private static Logger log = LoggerFactory.getLogger(RemotePCGSellerBackendServiceImpl.class);
    @Autowired
    private PCGSellerGoodsService pcgSellerGoodsService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;

    public DubboResult<Boolean> addGoods2Seller(long pcgId, long sellerId) {
        try {
            boolean ret = this.pcgSellerGoodsService.addGoods2Seller(sellerId, pcgId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRelation sellerId=" + sellerId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> remoteGoodsFromSeller(long pcgId, long sellerId) {
        try {
            boolean ret = this.pcgSellerGoodsService.removeGoodsFromSeller(sellerId, pcgId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("deleteRelation sellerId=" + sellerId + ",pcgId=" + pcgId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> removeSeller(long sellerId) {
        try {
            boolean ret = this.pcgSellerGoodsService.removeSeller(sellerId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("deleteAllBySellerId sellerId=" + sellerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createSeller(String name, String logo) {
        try {
            Long id = this.pcgSellerGoodsService.addSeller(name, logo);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("createSeller name=" + name + ",logo=" + logo, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGSellerDto>> findAll() {
        try {
            ArrayList<PCGSellerDto> ret = new ArrayList<PCGSellerDto>();
            List<PCGSellerEntity> list = this.pcgSellerGoodsService.findAll();
            for (PCGSellerEntity e : list) {
                PCGSellerDto dto = new PCGSellerDto();
                dto.setId(e.getId());
                dto.setLogo(e.getLogo());
                dto.setName(e.getName());
                dto.setPayload(e.getPayload());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editSellerNameAndLogo(long sellerId, String name, String logo) {
        try {
            this.pcgSellerGoodsService.updateSellerNameAndLogo(sellerId, name, logo);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("editSellerNameAndLogo sellerId=" + sellerId + ",name=" + name + ",logo=" + logo, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGSellerGoodsDto>> findAllBySellerId(long sellerId) {
        try {
            ArrayList<PCGSellerGoodsDto> ret = new ArrayList<PCGSellerGoodsDto>();
            List<PCGSellerGoodsEntity> list = this.pcgSellerGoodsService.findAllGoodsBySeller(sellerId);
            ArrayList<Long> pcgIds = new ArrayList<Long>();
            for (PCGSellerGoodsEntity e : list) {
                PCGSellerGoodsDto dto = new PCGSellerGoodsDto();
                dto.setId(e.getId());
                dto.setPayload(e.getPayload());
                dto.setPcgId(e.getPcgId());
                dto.setSellerId(e.getSellerId());
                ret.add(dto);
                pcgIds.add(dto.getPcgId());
            }
            Map<Long, PlatformCouponGoodsEntity> map = this.platformCouponGoodsService.findByIds(pcgIds);
            for (PCGSellerGoodsDto dto : ret) {
                dto.setTitle(map.get(dto.getPcgId()).getTitle());
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAllBySellerId sellerId=" + sellerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortSellerGoods(List<PCGSellerGoodsDto> list) {
        try {
            this.pcgSellerGoodsService.sortSellerGoods(list);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("sortSellerGoods", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortSellers(List<PCGSellerDto> sellers) {
        try {
            this.pcgSellerGoodsService.sortSellers(sellers);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("sortSellers", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

