/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsBatchServiceImpl;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="goodsBatchRedisService")
public class GoodsBatchRedisService
extends GoodsBatchServiceImpl
implements GoodsBatchService {
    private static final Logger log = LoggerFactory.getLogger(GoodsBatchRedisService.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private RedisBatchCache redisBatchCache = new RedisBatchCache();

    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.findNotDeletedBatchs(gtype, gid);
        ArrayList<GoodsBatchEntity> ret = new ArrayList<GoodsBatchEntity>();
        for (GoodsBatchEntity e : batchs) {
            if (!e.getEndDay().after(new Date())) continue;
            ret.add(e);
        }
        return ret;
    }

    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.redisBatchCache.getBatchsCache(gtype, gid);
        if (batchs == null) {
            batchs = super.findNotDeletedBatchs(gtype, gid);
            this.redisBatchCache.setBatchsCache(gtype, gid, batchs);
        }
        return batchs;
    }

    @Override
    public GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> normals = this.findNormalBatchs(gtype, gid);
        for (GoodsBatchEntity e : normals) {
            if (e.getStatus() != 2) continue;
            return e;
        }
        return null;
    }

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
        Long ret = super.createNormalBatch(gtype, gid, start, end);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
        Long ret = super.createLinkBatch(gtype, gid, start, end);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
        Long ret = super.createRepeatBatch(gtype, gid, start, end);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        Boolean ret = super.deleteBatch(gtype, gid, batchId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Boolean fillStockId(GoodsTypeEnum gtype, long gid, long goodsBatchId, long stockId) {
        Boolean ret = super.fillStockId(gtype, gid, goodsBatchId, stockId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public GoodsBatchEntity find(Long goodsBatchId) {
        return super.find(goodsBatchId);
    }

    @Override
    public Long getSumBatchStock(GoodsTypeEnum gtype, long gid) {
        return super.getSumBatchStock(gtype, gid);
    }

    @Override
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype, long gid) {
        return super.getTotalAllBatchStock(gtype, gid);
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        super.markBatchStatusNotUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        super.markBatchStatusUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        super.markBatchStatusUsing(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    public class RedisBatchCache {
        public List<GoodsBatchEntity> getBatchsCache(GoodsTypeEnum gtype, long gid) {
            String string = (String)GoodsBatchRedisService.this.redisTemplate.opsForValue().get((Object)this.getRedisBatchsKey(gtype, gid));
            if (string == null) {
                return null;
            }
            return JSONObject.parseArray((String)string, GoodsBatchEntity.class);
        }

        public void clearBatchsCache(GoodsTypeEnum gtype, long gid) {
            try {
                GoodsBatchRedisService.this.redisTemplate.delete((Object)this.getRedisBatchsKey(gtype, gid));
            }
            catch (Exception e) {
                log.error("RedisBatchCache.clearBatchsCache gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            }
        }

        public void setBatchsCache(GoodsTypeEnum gtype, long gid, List<GoodsBatchEntity> batchs) {
            String string = JSONObject.toJSONString(batchs);
            GoodsBatchRedisService.this.redisTemplate.opsForValue().set((Object)this.getRedisBatchsKey(gtype, gid), (Object)string);
            GoodsBatchRedisService.this.redisTemplate.expire((Object)this.getRedisBatchsKey(gtype, gid), 1L, TimeUnit.HOURS);
        }

        private String getRedisBatchsKey(GoodsTypeEnum gtype, long gid) {
            return RedisKeyTool.getRedisKey(this.getClass(), (String)"", (String)(gtype.getGtype() + "-" + gid));
        }
    }
}

