/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsCouponServiceImpl;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponService4Speed")
public class GoodsCouponService4Speed
extends GoodsCouponServiceImpl
implements GoodsCouponService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GoodsCouponService4Speed.class);
    private static final int RedisBatchSize = 10000;
    @Autowired
    private RedisTemplate<String, String> redisStringTemplate;
    @Autowired
    private RedisTemplate<String, Boolean> redisBooleanTemplate;
    private CouponQueueRedisCache couponQueueRedisCache;
    private BatchSaleoutRedisCache batchSaleoutRedisCache;
    private static LoadingCache<Long, Lock> batchLocks = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, Lock>(){

        public Lock load(Long key) throws Exception {
            return new ReentrantLock();
        }
    });

    public void afterPropertiesSet() throws Exception {
        this.batchSaleoutRedisCache = new BatchSaleoutRedisCache(this.redisBooleanTemplate);
        this.couponQueueRedisCache = new CouponQueueRedisCache(this.redisStringTemplate, this.batchSaleoutRedisCache);
    }

    @Override
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId) {
        try {
            DBTimeProfile.enter((String)"GoodsCouponService4Speed.takeNormalCoupon");
            if (!this.batchSaleoutRedisCache.isSaleOut(batch.getId())) {
                GoodsCouponEntity goodsCouponEntity = this.tryTakeCoupon(gtype, batch, consumerId, 1);
                return goodsCouponEntity;
            }
            throw new RuntimeGoodsException(ErrorCode.E0202005);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Boolean rollbackNormalCoupon(Long couponId) {
        Boolean success = super.rollbackNormalCoupon(couponId);
        return success;
    }

    private GoodsCouponEntity origionTakeCouponByLock(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId) {
        if (((Lock)batchLocks.getUnchecked((Object)batch.getId())).tryLock()) {
            return super.takeNormalCoupon(gtype, batch, consumerId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsCouponEntity tryTakeCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, int tryCount) {
        if (tryCount > 3) {
            throw new RuntimeGoodsException(ErrorCode.E0202003);
        }
        try {
            DBTimeProfile.enter((String)"GoodsCouponService4Speed.tryTakeCoupon");
            long goodsBatchId = batch.getId();
            long gid = batch.getGid();
            long size = this.couponQueueRedisCache.getQueueSize(goodsBatchId);
            if (size > 0L) {
                GoodsCouponEntity entity = this.couponQueueRedisCache.pop(goodsBatchId);
                boolean success = this.takeCoupon4Point(gtype, gid, goodsBatchId, entity.getGoodsCouponId(), consumerId);
                if (success) {
                    GoodsCouponEntity goodsCouponEntity = entity;
                    return goodsCouponEntity;
                }
                GoodsCouponEntity goodsCouponEntity = this.tryTakeCoupon(gtype, batch, consumerId, tryCount++);
                return goodsCouponEntity;
            }
            this.couponQueueRedisCache.tryLoadCouponByBatchId(gtype, gid, goodsBatchId, 10000);
            GoodsCouponEntity goodsCouponEntity = this.tryTakeCoupon(gtype, batch, consumerId, tryCount++);
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public class CouponQueueRedisCache {
        private RedisTemplate<String, String> redisTemplate;
        private BatchSaleoutRedisCache batchSaleoutRedisCache;

        public CouponQueueRedisCache(RedisTemplate<String, String> redis, BatchSaleoutRedisCache batchSaleoutRedisCache) {
            this.redisTemplate = redis;
            this.batchSaleoutRedisCache = batchSaleoutRedisCache;
        }

        public long getQueueSize(long goodsBatchId) {
            return this.redisTemplate.opsForSet().size((Object)this.getBatchCouponsKey(goodsBatchId));
        }

        public GoodsCouponEntity pop(long goodsBatchId) {
            GoodsCouponEntity entity = (GoodsCouponEntity)JSONObject.parseObject((String)((String)this.redisTemplate.opsForSet().pop((Object)this.getBatchCouponsKey(goodsBatchId))), GoodsCouponEntity.class);
            return entity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tryLoadCouponByBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId, int limit) {
            long value = this.redisTemplate.opsForValue().increment((Object)this.getBatchLockKey(goodsBatchId), 1L);
            if (value != 1L) {
                throw new RuntimeGoodsException(ErrorCode.E0202004);
            }
            try {
                DBTimeProfile.enter((String)"redis tryLoadCouponByBatchId");
                this.redisTemplate.expire((Object)this.getBatchLockKey(goodsBatchId), 30L, TimeUnit.SECONDS);
                List<GoodsCouponEntity> list = GoodsCouponService4Speed.this.loadCouponByBatchId(gtype, gid, goodsBatchId, limit);
                if (list.isEmpty()) {
                    this.batchSaleoutRedisCache.setSaleOut(goodsBatchId, true);
                } else {
                    Object[] array = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        array[i] = JSONObject.toJSONString((Object)list.get(i));
                    }
                    this.redisTemplate.opsForSet().add((Object)this.getBatchCouponsKey(goodsBatchId), array);
                    this.redisTemplate.expire((Object)this.getBatchCouponsKey(goodsBatchId), 1L, TimeUnit.HOURS);
                    this.batchSaleoutRedisCache.setSaleOut(goodsBatchId, false);
                }
            }
            finally {
                DBTimeProfile.release();
                this.redisTemplate.delete((Object)this.getBatchLockKey(goodsBatchId));
            }
        }

        private String getBatchCouponsKey(Long goodsBatchId) {
            return RedisKeyTool.getRedisKey(this.getClass(), (String)"batch_coupons", (String)(goodsBatchId + ""));
        }

        private String getBatchLockKey(Long goodsBatchId) {
            return RedisKeyTool.getRedisKey(this.getClass(), (String)"batch_lock", (String)(goodsBatchId + ""));
        }
    }

    public class BatchSaleoutRedisCache {
        private RedisTemplate<String, Boolean> redisTemplate;

        public BatchSaleoutRedisCache(RedisTemplate<String, Boolean> redis) {
            this.redisTemplate = redis;
        }

        public boolean isSaleOut(long batchId) {
            Boolean saleout = (Boolean)this.redisTemplate.opsForValue().get((Object)this.getSaleOutKey(batchId));
            if (saleout == null) {
                return false;
            }
            return saleout;
        }

        public void setSaleOut(long batchId, boolean saleout) {
            this.redisTemplate.opsForValue().set((Object)this.getSaleOutKey(batchId), (Object)saleout);
            this.redisTemplate.expire((Object)this.getSaleOutKey(batchId), 1L, TimeUnit.MINUTES);
        }

        private String getSaleOutKey(long batchId) {
            return "goods-" + this.getClass().getSimpleName() + "-saleout-" + batchId;
        }
    }
}

