/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponService")
public class GoodsCouponServiceImpl
implements GoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponDao goodsCouponDao;
    @Autowired
    private RemoteStockService remoteStockService;

    @Override
    public GoodsCouponEntity find(Long goodsCouponId) {
        return this.goodsCouponDao.selectByCouponId(goodsCouponId);
    }

    @Override
    public long findNotUsedCount(GoodsBatchEntity batch) {
        if (batch.getBatchType() == 0) {
            return this.goodsCouponDao.selectCountByBatchNotUsed(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid(), batch.getId());
        }
        DubboResult ret = this.remoteStockService.find(batch.getStockId().longValue());
        if (ret.isSuccess()) {
            return (Long)ret.getResult();
        }
        throw new RuntimeGoodsException(ErrorCode.E0203003);
    }

    @Override
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link) {
        int ret = this.goodsCouponDao.updateLinkCoupon(gtype, gid, batchId, link);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public void importLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        this.goodsCouponDao.insertLinkCoupon(gtype, gid, goodsBatchId, goodsCouponId, link);
    }

    @Override
    public void importRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code, String password) {
        this.goodsCouponDao.insertRepeatCoupon(gtype, gid, goodsBatchId, goodsCouponId, code, password);
    }

    @Override
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password) {
        int ret = this.goodsCouponDao.updateRepeatCoupon(gtype, gid, batchId, code, password);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Integer importNormalCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<GoodsCouponDao.CouponFormat> coupons) {
        if (coupons.size() > 1000000) {
            throw new RuntimeException("\u8d85\u51fa100W\uff0c\u62d2\u7edd\u5bfc\u5165");
        }
        int MAX_RECORDS = 20000;
        int size = coupons.size();
        int batchs = size % 20000 == 0 ? size / 20000 : size / 20000 + 1;
        ArrayList group = new ArrayList(batchs);
        HashMap<Integer, AtomicInteger> countMap = new HashMap<Integer, AtomicInteger>();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < batchs; ++i) {
            ArrayList l = new ArrayList(20000);
            group.add(l);
            countMap.put(i, new AtomicInteger());
        }
        block1: for (GoodsCouponDao.CouponFormat cf : coupons) {
            if (set.add(cf.getCode())) {
                for (int i = 0; i < group.size(); ++i) {
                    List cflist = (List)group.get(i);
                    if (((AtomicInteger)countMap.get(i)).get() >= 20000) continue;
                    ((AtomicInteger)countMap.get(i)).incrementAndGet();
                    cflist.add(cf);
                    continue block1;
                }
                continue;
            }
            log.debug("\u91cd\u590d\u5238\u7801 code=" + cf.getCode());
        }
        int totalSuccess = 0;
        for (List list : group) {
            if (list.isEmpty()) continue;
            totalSuccess += this.goodsCouponDao.insertBatchImport(gtype, gid, batchId, list);
        }
        return totalSuccess;
    }

    @Override
    public Page<GoodsCouponEntity> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex) {
        Page page = new Page(pageSize, pageIndex);
        int count = this.goodsCouponDao.selectCountByBatch(gtype, gid, batchId);
        int start = (pageIndex - 1) * pageSize;
        int limit = pageSize;
        List<GoodsCouponEntity> list = this.goodsCouponDao.selectPageByBatchId(gtype, gid, batchId, start, limit);
        page.setTotalPages(count % pageSize == 0 ? count / pageSize : count / pageSize + 1);
        page.setList(list);
        page.setTotalCount(count);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId) {
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.takeNormalCoupon");
            GoodsCouponEntity entity = this.goodsCouponDao.selectOneCouponNotUsed(gtype, batch.getGid(), batch.getId());
            boolean success = this.takeCoupon4Point(gtype, batch.getGid(), batch.getId(), entity.getGoodsCouponId(), consumerId);
            if (success) {
                GoodsCouponEntity goodsCouponEntity = entity;
                return goodsCouponEntity;
            }
            GoodsCouponEntity goodsCouponEntity = null;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsCouponEntity takeLinkCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum) {
        DubboResult stockRet = this.remoteStockService.decreaseGoodStock(batch.getStockId().longValue(), bizNum);
        if (!stockRet.isSuccess() || !((Boolean)stockRet.getResult()).booleanValue()) {
            return null;
        }
        return this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getId(), batch.getId());
    }

    @Override
    public GoodsCouponEntity takeRepeatCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum) {
        DubboResult stockRet = this.remoteStockService.decreaseGoodStock(batch.getStockId().longValue(), bizNum);
        if (!stockRet.isSuccess()) {
            return null;
        }
        if (!((Boolean)stockRet.getResult()).booleanValue()) {
            return null;
        }
        return this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getGid(), batch.getId());
    }

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponDao.updateCoupnoMarkUsed(couponId, orderId);
    }

    @Override
    public Boolean rollbackNormalCoupon(Long couponId) {
        int ret = this.goodsCouponDao.updateCouponMarkRollback(couponId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    protected List<GoodsCouponEntity> loadCouponByBatchId(GoodsTypeEnum gtype, long gid, long batchId, int limit) {
        return this.goodsCouponDao.selectBatchNotUsed(gtype, gid, batchId, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean takeCoupon4Point(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, long consumerId) {
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.takeCoupon4Point");
            int ret = this.goodsCouponDao.updateCouponMarkLocked(gtype, gid, goodsBatchId, goodsCouponId, consumerId);
            if (ret == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsCouponEntity findOneByGoodsBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        return this.goodsCouponDao.selectOneByGoodsBatchId(gtype, gid, goodsBatchId);
    }

    @Override
    public List<GoodsCouponEntity> searchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code) {
        return this.goodsCouponDao.selectSearchByCode(gtype, gid, goodsBatchId, code);
    }

    @Override
    public long findTotalAllCount(GoodsTypeEnum gtype, long gid, long batchId) {
        return this.goodsCouponDao.selectCountByBatch(gtype, gid, batchId);
    }
}

