/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pCGCategoryGoodsService")
public class PCGCategoryGoodsServiceImpl
implements PCGCategoryGoodsService {
    @Autowired
    private PCGCategoryGoodsDao pcgCategoryGoodsDao;
    @Autowired
    private PCGCategoryDao pcgCategoryDao;

    @Override
    public Boolean addGoods2Category(long pcgId, long categoryId) {
        int max = this.pcgCategoryGoodsDao.selectMaxPayloadByCategory(categoryId);
        int ret = this.pcgCategoryGoodsDao.insertGoods2Category(pcgId, categoryId, max + 1);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean removeGoodsFromCategory(long pcgId, long categoryId) {
        int ret = this.pcgCategoryGoodsDao.deleteGoods2Category(pcgId, categoryId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(value="pcg")
    public Boolean removeCategory(long categoryId) {
        this.pcgCategoryDao.delete(categoryId);
        this.pcgCategoryGoodsDao.deleteCategoryRelation(categoryId);
        return true;
    }

    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        this.pcgCategoryGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }

    @Override
    public Long addCategory(String name) {
        return this.pcgCategoryDao.insert(name);
    }

    @Override
    public void updateCategoryName(Long id, String name) {
        this.pcgCategoryDao.updateName(id, name);
    }

    @Override
    public void updateCategoryPayload(Long id, int payload) {
        this.pcgCategoryDao.updatePayload(id, payload);
    }

    @Override
    public List<PCGCategoryEntity> findAll() {
        return this.pcgCategoryDao.selectAll();
    }

    @Override
    public PCGCategoryEntity findCategory(Long id) {
        return this.pcgCategoryDao.select(id);
    }

    @Override
    public void sortCategories(List<PCGCategoryDto> categories) {
        for (PCGCategoryDto dto : categories) {
            this.pcgCategoryDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }

    @Override
    public void sortCategoryGoods(List<PCGCategoryGoodsDto> list) {
        for (PCGCategoryGoodsDto dto : list) {
            this.pcgCategoryGoodsDao.updatePayload(dto.getCategoryId(), dto.getPcgId(), dto.getPayload());
        }
    }

    @Override
    public List<PCGCategoryGoodsEntity> findAllGoodsByCategory(long categoryId) {
        return this.pcgCategoryGoodsDao.selectByCategory(categoryId);
    }
}

