/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGFilterConfigDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategroySellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigServiceImpl
implements PCGFilterConfigService {
    @Autowired
    private PCGFilterConfigDao pCGFilterConfigDao;
    @Autowired
    private PlatformCouponGoodsDao platformCouponGoodsDao;
    @Autowired
    private PCGCategoryDao pCGCategoryDao;
    @Autowired
    private PCGSellerDao pCGSellerDao;

    @Override
    public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId) {
        List<Long> pcgIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 1);
        return this.platformCouponGoodsDao.selectByIds(pcgIds);
    }

    @Override
    public List<PCGCategoryEntity> findCategoryFilterList(Long appId) {
        List<Long> categoryIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 2);
        return this.pCGCategoryDao.selectByIds(categoryIds);
    }

    @Override
    public List<PCGSellerEntity> findSellerFilterList(Long appId) {
        List<Long> sellerIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 3);
        return this.pCGSellerDao.selectByIds(sellerIds);
    }

    @Override
    public List<PCGCategroySellerGoodsEntity> findCounponBelong(Long goodsId) {
        return this.pCGFilterConfigDao.selectCounponBelong(goodsId);
    }

    @Override
    public Long insert(long appId, int type, long targetId) {
        return this.pCGFilterConfigDao.insert(appId, type, targetId);
    }

    @Override
    public int delete(long appId, int type, long targetId) {
        return this.pCGFilterConfigDao.delete(appId, type, targetId);
    }

    @Override
    public PCGFilterConfigEntity select(Long id) {
        return this.pCGFilterConfigDao.select(id);
    }

    @Override
    public Page<PlatformCouponGoodsEntity> selectPCGCategroySellerGoodsList(Long appId, int pageSize, int pageIndex) {
        int start = pageSize * (pageIndex - 1);
        int limit = pageSize;
        int total = this.pCGFilterConfigDao.selectPCGCategroySellerGoodsCount(appId);
        List<PlatformCouponGoodsEntity> list = this.pCGFilterConfigDao.selectPCGCategroySellerGoodsList(appId, limit, start);
        Page page = new Page(pageSize, pageIndex);
        page.setList(list);
        page.setTotalCount(total);
        page.setTotalPages(total % pageSize == 0 ? total / pageSize : total / pageSize + 1);
        return page;
    }

    @Override
    public List<Long> selectPCGFilterTargetIds(Long appId, Integer type) {
        return this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, type);
    }
}

