/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pCGSellerGoodsService")
public class PCGSellerGoodsServiceImpl
implements PCGSellerGoodsService {
    @Autowired
    private PCGSellerGoodsDao pcgSellerGoodsDao;
    @Autowired
    private PCGSellerDao pcgSellerDao;

    @Override
    public Boolean addGoods2Seller(long sellerId, long pcgId) {
        int max = this.pcgSellerGoodsDao.selectMaxPayloadBySellerId(sellerId);
        int ret = this.pcgSellerGoodsDao.insertGoods2Seller(pcgId, sellerId, max + 1);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean removeGoodsFromSeller(long sellerId, long pcgId) {
        int ret = this.pcgSellerGoodsDao.deleteGoods2Seller(pcgId, sellerId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(value="pcg")
    public Boolean removeSeller(long sellerId) {
        this.pcgSellerDao.delete(sellerId);
        this.pcgSellerGoodsDao.deleteSellerRelation(sellerId);
        return true;
    }

    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        this.pcgSellerGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }

    @Override
    public Long addSeller(String name, String logo) {
        return this.pcgSellerDao.insert(name, logo);
    }

    @Override
    public List<PCGSellerEntity> findAll() {
        return this.pcgSellerDao.selectAll();
    }

    @Override
    public List<PCGSellerGoodsEntity> findAllGoodsBySeller(long sellerId) {
        return this.pcgSellerGoodsDao.selectBySeller(sellerId);
    }

    @Override
    public PCGSellerEntity findSeller(Long id) {
        return this.pcgSellerDao.select(id);
    }

    @Override
    public void sortSellerGoods(List<PCGSellerGoodsDto> list) {
        for (PCGSellerGoodsDto dto : list) {
            this.pcgSellerGoodsDao.updatePayload(dto.getSellerId(), dto.getPcgId(), dto.getPayload());
        }
    }

    @Override
    public void sortSellers(List<PCGSellerDto> sellers) {
        for (PCGSellerDto dto : sellers) {
            this.pcgSellerDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }

    @Override
    public void updateSellerPayload(Long id, int payload) {
        this.pcgSellerDao.updatePayload(id, payload);
    }

    @Override
    public void updateSellerNameAndLogo(Long id, String name, String logo) {
        this.pcgSellerDao.updateNameAndLogo(id, name, logo);
    }
}

