/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="platformCouponGoodsService")
public class PlatformCouponGoodsServiceImpl
implements PlatformCouponGoodsService {
    @Autowired
    private PlatformCouponGoodsDao platformCouponGoodsDao;
    @Autowired
    private RemoteIDMakerService remoteIDMakerService;

    @Override
    public PlatformCouponGoodsEntity find(long pcgId) {
        return this.platformCouponGoodsDao.selectByPcgId(pcgId);
    }

    @Override
    public Map<Long, PlatformCouponGoodsEntity> findByIds(List<Long> pcgIds) {
        List<PlatformCouponGoodsEntity> list = this.platformCouponGoodsDao.selectByIds(pcgIds);
        HashMap<Long, PlatformCouponGoodsEntity> map = new HashMap<Long, PlatformCouponGoodsEntity>();
        for (PlatformCouponGoodsEntity e : list) {
            map.put(e.getPcgId(), e);
        }
        return map;
    }

    @Override
    public Long createPlatformCouponGoods(PCGInsertDto goods) {
        DubboResult ret = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.GOODS.getType());
        if (ret.isSuccess()) {
            goods.setPcgId((Long)ret.getResult());
            this.platformCouponGoodsDao.insert(goods);
            return (Long)ret.getResult();
        }
        throw new RuntimeGoodsException(ErrorCode.E0203002);
    }

    @Override
    public void editPlatformCouponGoods(Long pcgId, PCGEditDto goods) {
        this.platformCouponGoodsDao.updateEditGoods(pcgId, goods);
    }

    @Override
    public boolean editPlatformCouponType(Long pcgId, int couponType) {
        int ret = this.platformCouponGoodsDao.updateCouponType(pcgId, couponType);
        return ret == 1;
    }

    @Override
    public void onshelfGoods(Long pcgId) {
        this.platformCouponGoodsDao.updateStatusOnShelf(pcgId);
    }

    @Override
    public void offshelfGoods(Long pcgId) {
        this.platformCouponGoodsDao.updateStatusOffShelf(pcgId);
    }

    @Override
    public void deleteGoods(Long pcgId) {
        this.platformCouponGoodsDao.markDelete(pcgId);
    }

    @Override
    public List<PlatformCouponGoodsEntity> searchByName(String name) {
        return this.platformCouponGoodsDao.selectSearchByName(name);
    }

    @Override
    public Page<PlatformCouponGoodsEntity> findPage(String name, Integer pcgStatus, int pageSize, int pageIndex) {
        int start = pageSize * (pageIndex - 1);
        int limit = pageSize;
        int total = this.platformCouponGoodsDao.selectCountBySearch(name, pcgStatus);
        List<PlatformCouponGoodsEntity> list = this.platformCouponGoodsDao.selectBySearch(name, pcgStatus, start, limit);
        Page page = new Page(pageSize, pageIndex);
        page.setList(list);
        page.setTotalCount(total);
        page.setTotalPages(total % pageSize == 0 ? total / pageSize : total / pageSize + 1);
        return page;
    }
}

