/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigBOImpl
implements PCGFilterConfigBO {
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    protected RemoteAppService remoteAppService;
    @Autowired
    protected RemoteStockBackendService remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, 1);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    if (pcgId - filterGoodsId != 0L) continue;
                    ps.remove();
                }
            }
        }
        return pcgIds;
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGCategoryEntity> cats = this.pCGFilterConfigService.findCategoryFilterList(appId);
        ArrayList<Long> catIds = new ArrayList<Long>();
        for (PCGCategoryEntity e : cats) {
            catIds.add(e.getId());
        }
        if (catIds.contains(categoryId)) {
            return new Page(pageSize.intValue(), pageIndex.intValue());
        }
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = this.pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pcgIds = this.filterGoods(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (!pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() != pcgId.longValue()) continue;
            return p.getPayLoad();
        }
        return 0;
    }

    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId, Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads, Integer pageIndex, Integer pageSize) {
        ArrayList<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        for (Long pcgIdKey : pcgs.keySet()) {
            DubboResult result;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, pce.getSwitches().intValue()) && !directionals.isEmpty()) {
                gdce1 = directionals.get(appId + "-" + pcgIdKey);
                gdce2 = directionals.get("0-" + pcgIdKey);
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, (Object)gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce2.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null && (Long)result.getResult() == 0L) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            if (gdce1 != null) {
                ObjectUtil.convert((Object)gdce1, (Object)gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce1.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null && (Long)result.getResult() == 0L) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            psgd.setGoodsDirectionalConfigDto(gc);
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(Long.valueOf(pcgStock));
            goodsList.add(psgd);
        }
        return this.page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        List<PCGSellerEntity> sels = this.pCGFilterConfigService.findSellerFilterList(appId);
        ArrayList<Long> catIds = new ArrayList<Long>();
        for (PCGSellerEntity e : sels) {
            catIds.add(e.getId());
        }
        if (catIds.contains(sellerId)) {
            return new Page(pageSize.intValue(), pageIndex.intValue());
        }
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = this.pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pcgIds = this.filterGoods(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (!pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    @Override
    public PCGCategorySellerGoodsDto checkExchange(PCGCategorySellerGoodsDto pce, GoodsDirectionalConfigEntity gdce1, GoodsDirectionalConfigEntity gdce2, Long appId, Long consumerId, Long consumerIntegral, Integer devRate, String unitName) {
        DubboResult result;
        long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        pce.setStock(Long.valueOf(pcgStock));
        int exchangeType = 0;
        boolean exchangeFlag = true;
        boolean dayLimitFlag = true;
        Integer minPrice = null;
        Integer count = -1;
        if (pce.getLimitPerConsumer() != null) {
            count = this.goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pce.getPcgId(), consumerId);
        }
        if (gdce2 != null) {
            Long stockId = gdce2.getStockId();
            if (stockId != null) {
                result = this.remoteStockBackendService.find(stockId.longValue());
                if (result != null && result.isSuccess() && result.getResult() != null && (Long)result.getResult() == 0L) {
                    exchangeFlag = false;
                }
                if (gdce2.getMinPrice() != null) {
                    minPrice = gdce2.getMinPrice();
                }
                if (gdce2.getDayLimit() != null && gdce2.getDayLimit() - count <= 0) {
                    dayLimitFlag = false;
                }
            }
        } else if (gdce1 != null) {
            Long stockId2;
            if (gdce1.getMinPrice() != null) {
                minPrice = gdce1.getMinPrice();
            }
            if ((stockId2 = gdce1.getStockId()) != null && (result = this.remoteStockBackendService.find(stockId2.longValue())) != null && result.isSuccess() && result.getResult() != null && (Long)result.getResult() == 0L) {
                exchangeFlag = false;
            }
            if (gdce1.getDayLimit() != null && gdce1.getDayLimit() - count == 0) {
                dayLimitFlag = false;
            }
        }
        if (minPrice != null) {
            pce.setMinPrice(minPrice);
        }
        pce.setMinPrice(Integer.valueOf(pce.getMinPrice() * devRate));
        if (pce.getLimitPerConsumer() != null && pce.getLimitPerConsumer() - count <= 0 || !dayLimitFlag) {
            exchangeType = 1;
            pce.setPayLoad(Integer.valueOf(pce.getPayLoad() == null ? 0 : pce.getPayLoad() + 400));
        } else if (consumerIntegral <= (long)pce.getMinPrice().intValue()) {
            exchangeType = 2;
        } else if (pce.getStock() == 0L || !exchangeFlag) {
            exchangeType = 3;
            pce.setPayLoad(Integer.valueOf(pce.getPayLoad() == null ? 0 : pce.getPayLoad() + 300));
        } else {
            exchangeType = 4;
        }
        pce.setExchangeType(Integer.valueOf(exchangeType));
        List<GoodsBatchDto> goodsBatchs = this.goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        String cuurDate = this.sdf2.format(new Date());
        for (int i = 0; i < goodsBatchs.size(); ++i) {
            if (goodsBatchs.get(i).getStock() <= 0L || Integer.parseInt(this.sdf2.format(goodsBatchs.get(i).getEndDay())) < Integer.parseInt(cuurDate)) continue;
            pce.setStartDate(this.sdf.format(goodsBatchs.get(i).getStartDay()));
            pce.setEndDate(this.sdf.format(goodsBatchs.get(i).getEndDay()));
            break;
        }
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank((String)pce.getEndDate())) {
            pce.setStartDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            pce.setEndDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
        }
        pce.setUnitName(unitName);
        return pce;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        int totalPages;
        Page page = new Page(pageSize.intValue(), pageIndex.intValue());
        ArrayList<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int n = totalPages = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total && pageSize * (pageIndex + 1) != i; ++i) {
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize.intValue());
        page.setCurrent(pageIndex.intValue());
        return page;
    }

    public static class PCGIdAndPayLoad {
        private Long pagId;
        private Integer payLoad;

        public PCGIdAndPayLoad() {
        }

        public PCGIdAndPayLoad(Long pcgId, Integer payLoad) {
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }

        public Long getPagId() {
            return this.pagId;
        }

        public Integer getPayLoad() {
            return this.payLoad;
        }
    }
}

