/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.pcg.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.PcgCreditsCalculteTool;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pCGUtilBO")
public class PCGUtilBOImpl
implements PCGUtilBO {
    private static Logger log = LoggerFactory.getLogger(PCGUtilBOImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private PCGFilterConfigService pcgFilterConfigService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;

    @Override
    public boolean canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) throws Exception {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (pcg == null) {
            log.error("canTakePlatformCouponGoods pcgId=" + pcgId + ", but query result is null");
            throw new Exception("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (pcg.getDeleted().booleanValue()) {
            log.error("canTakePlatformCouponGoods pcgId=" + pcgId + ", but query result is deleted");
            throw new Exception("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (pcg.getPcgStatus() == 0) {
            throw new Exception("\u5546\u54c1\u5df2\u4e0b\u67b6");
        }
        if (this.isInBlack(pcg, appId)) {
            throw new Exception("\u5546\u54c1\u65e0\u6cd5\u5151\u6362");
        }
        if (pcg.getLimitPerConsumer() != null) {
            int limit = pcg.getLimitPerConsumer();
            int count = this.goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
            if (count > limit) {
                throw new Exception("\u8d85\u51fa\u7528\u6237\u5151\u6362\u9650\u5236");
            }
        }
        if (!this.checkStockEnough(pcgId, appId, consumerId)) {
            throw new Exception("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        return true;
    }

    @Override
    public boolean checkStockEnough(long pcgId, long appId, long consumerId) {
        DubboResult stockRet;
        Long stock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pcgId);
        if (stock == null || stock <= 0L) {
            log.error("total stock not enought ,pcgId=" + pcgId + ",appId=" + appId + ",consumerId=" + consumerId + ",stock=" + stock);
            return false;
        }
        GoodsDirectionalConfigEntity config = this.goodsDirectionalConfigService.findByGoodsAndAppIncludeShared(GoodsTypeEnum.PLATFORM, pcgId, appId);
        if (!(config == null || (stockRet = this.remoteStockService.find(config.getStockId().longValue())).isSuccess() && (Long)stockRet.getResult() > 0L)) {
            log.error("directional stock not enought ,pcgId=" + pcgId + ",appId=" + appId + ",consumerId=" + consumerId + ",stock=" + stockRet.getResult());
            return false;
        }
        Integer dayLimit = null;
        GoodsDirectionalConfigEntity e = this.goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId);
        if (e != null && e.getDayLimit() != null) {
            dayLimit = e.getDayLimit();
        }
        if (dayLimit == null && (e = this.goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId)) != null && e.getDayLimit() != null) {
            dayLimit = e.getDayLimit();
        }
        if (dayLimit != null) {
            if (dayLimit <= 0) {
                return false;
            }
            DubboResult todaySales = this.remoteSaleLimitService.findSaleCountToday(Integer.valueOf(1), e.getId() + "");
            if (!todaySales.isSuccess()) {
                log.error("today sales fail,pcgId=" + pcgId + ",appId=" + appId + ",consumerId=" + consumerId);
                return false;
            }
            if (todaySales.getResult() != null && (Long)todaySales.getResult() >= (long)dayLimit.intValue()) {
                log.error("today sales enough,pcgId=" + pcgId + ",appId=" + appId + ",consumerId=" + consumerId + ",sales=" + todaySales.getResult());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isInBlack(PlatformCouponGoodsEntity pcg, long appId) {
        List<PlatformCouponGoodsEntity> goods = this.pcgFilterConfigService.findGoodsFilterList(appId);
        HashSet<Long> blackGoodsIds = new HashSet<Long>();
        for (PlatformCouponGoodsEntity e : goods) {
            blackGoodsIds.add(e.getPcgId());
        }
        if (blackGoodsIds.contains(pcg.getPcgId())) {
            return true;
        }
        List<PCGFilterConfigDto> belongs = this.pcgFilterConfigService.findCounponBelong(pcg.getPcgId());
        if (belongs.isEmpty()) {
            return false;
        }
        List<PCGCategoryEntity> cates = this.pcgFilterConfigService.findCategoryFilterList(appId);
        List<PCGSellerEntity> sellers = this.pcgFilterConfigService.findSellerFilterList(appId);
        HashSet<Long> catSet = new HashSet<Long>();
        for (PCGCategoryEntity c : cates) {
            catSet.add(c.getId());
        }
        HashSet<Long> sellerSet = new HashSet<Long>();
        for (PCGSellerEntity e : sellers) {
            sellerSet.add(e.getId());
        }
        for (PCGFilterConfigDto f : belongs) {
            if (!(f.getType() == 2 ? catSet.contains(f.getTargetId()) : f.getType() == 3 && sellerSet.contains(f.getTargetId()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        Integer price = this.goodsDirectionalConfigService.findDirectionalCreditsPriceIncludeShared(GoodsTypeEnum.PLATFORM, pcgId, appId);
        if (price != null) {
            Long credits = PcgCreditsCalculteTool.getCredits(price.intValue(), this.remoteAppService.find(Long.valueOf(appId)).getCreditsRate().intValue());
            return credits;
        }
        Long credits = PcgCreditsCalculteTool.getCredits(pcg.getMinPrice().intValue(), this.remoteAppService.find(Long.valueOf(appId)).getCreditsRate().intValue());
        return credits;
    }
}

