/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsCouponBackendService")
public class RemoteGoodsCouponBackendServiceImpl
implements RemoteGoodsCouponBackendService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponBackendServiceImpl.class);
    @Autowired
    private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;

    public DubboResult<Long> createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
        try {
            Long batchId = this.goodsBatchCouponBackendBO.createNormalBatch(gtype, gid, start, end);
            return DubboResult.successResult((Object)batchId);
        }
        catch (Exception e) {
            log.error("createNormalBatch gtype=" + gtype + ",gid=" + gid + ",start=" + start + ",end=" + end, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String link, long stock) {
        try {
            Long batchId = this.goodsBatchCouponBackendBO.createLinkBatch(gtype, gid, start, end, link, stock);
            return DubboResult.successResult((Object)batchId);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String code, String password, long stock) {
        try {
            Long batchId = this.goodsBatchCouponBackendBO.createRepeatBatch(gtype, gid, start, end, code, password, stock);
            return DubboResult.successResult((Object)batchId);
        }
        catch (Exception e) {
            log.error("createRepeatBatch gtype=" + gtype + ",gid=" + gid + ",start=" + start + ",end=" + end + ",code=" + code + ",password=" + password + ",stock=" + stock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link, long changeStock) {
        try {
            boolean success = this.goodsBatchCouponBackendBO.updateLinkBatch(gtype, gid, batchId, link, changeStock);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("updateLinkBatch gtype=" + gtype + ",gid=" + gid + ",batchId=" + batchId + ",link=" + link + ",changeStock=" + changeStock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password, long changeStock) {
        try {
            boolean success = this.goodsBatchCouponBackendBO.updateRepeatBatch(gtype, gid, batchId, code, password, changeStock);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("updateRepeatBatch gtype=" + gtype + ",gid=" + gid + ",batchId=" + batchId + ",code=" + code + ",password=" + password + ",changeStock=" + changeStock, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsBatchDto>> findBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            List<GoodsBatchDto> ret = this.goodsBatchCouponBackendBO.findBatchs(gtype, gid);
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findBatchs gtype=" + gtype + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> importNormalCoupons(GoodsTypeEnum gtype, long gid, Long batchId, String downloadUrl) {
        try {
            Long importLogId = this.goodsBatchCouponBackendBO.importNormalCoupons(gtype, gid, batchId, downloadUrl);
            return DubboResult.successResult((Object)importLogId);
        }
        catch (Exception e) {
            log.error("importNormalCoupons gtype=" + gtype + ",gid=" + gid + ",batchId=" + batchId + ",downloadUrl=" + downloadUrl, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchImportLogDto> findBatchImportLog(Long goodsBatchImportLogId) {
        try {
            GoodsBatchImportLogDto dto = this.goodsBatchCouponBackendBO.findBatchImportLog(goodsBatchImportLogId);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findBatchImportLog goodsBatchImportLogId=" + goodsBatchImportLogId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        try {
            boolean success = this.goodsBatchCouponBackendBO.deleteBatch(gtype, gid, batchId);
            return DubboResult.successResult((Object)success);
        }
        catch (Exception e) {
            log.error("deleteBatch gtype=" + gtype + ",gid=" + gid + ",batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchDto> findBatchStock(GoodsTypeEnum gtype, long gid, long batchId) {
        try {
            GoodsBatchDto stock = this.goodsBatchCouponBackendBO.findBatchStock(gtype, gid, batchId);
            return DubboResult.successResult((Object)stock);
        }
        catch (Exception e) {
            log.error("findBatchStock gtype=" + gtype + ",gid=" + gid + ",batchId=" + batchId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<GoodsCouponDto>> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex) {
        try {
            Page<GoodsCouponDto> ret = this.goodsBatchCouponBackendBO.findPage(gtype, gid, batchId, pageSize, pageIndex);
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findPage gtype=" + gtype.getGtype() + ",gid=" + gid + ",batchId=" + batchId + ",pageSize=" + pageSize + ",pageIndex=" + pageIndex, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsCouponDto>> findCouponByCode(GoodsTypeEnum gtype, long gid, long batchId, String code) {
        try {
            List<GoodsCouponDto> list = this.goodsBatchCouponBackendBO.findCouponByCode(gtype, gid, batchId, code);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findCouponByCode gtype=" + gtype.getGtype() + ",gid=" + gid + ",batchId=" + batchId + ",code=" + code, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

