/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsCouponService")
public class RemoteGoodsCouponServiceImpl
implements RemoteGoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId, String bizNum) {
        try {
            DBTimeProfile.enter((String)"RemoteGoodsCouponServiceImpl.takeCoupon");
            GoodsCouponEntity coupon = this.goodsCouponBO.takeCoupon(gtype, gid, consumerId, bizNum);
            GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
            DubboResult dubboResult = DubboResult.successResult((Object)dto);
            return dubboResult;
        }
        catch (RuntimeGoodsException rge) {
            log.error("takeCoupon gtype=" + gtype.getGtype() + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)rge);
            DubboResult dubboResult = DubboResult.failResult((String)rge.getResultMessage());
            return dubboResult;
        }
        catch (Exception e) {
            log.error("takeCoupon gtype=" + gtype.getGtype() + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public DubboResult<Boolean> completeCoupon(Long couponId, long orderId) {
        try {
            this.goodsCouponBO.completeCoupon(couponId, orderId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("takeCoupon couponId=" + couponId + ",orderId=" + orderId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackCoupon(Long couponId, String bizNum) {
        try {
            Boolean ret = this.goodsCouponBO.rollbackCoupon(couponId, bizNum);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("rollbackCoupon couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public GoodsCouponDto findCoupon(long couponId) {
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long batchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
        GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
        dto.setOverDue(batch.getEndDay());
        return dto;
    }
}

