/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsInfoService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGGoodsInfoService")
public class RemotePCGGoodsInfoServiceImpl
implements RemotePCGGoodsInfoService {
    private static Logger log = LoggerFactory.getLogger(RemotePCGGoodsInfoServiceImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGFilterConfigBO pCGFilterConfigBO;

    public PCGDto find(long pcgId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (pcg == null) {
            return null;
        }
        PCGDto dto = PCGConvertUtil.convert(pcg);
        return dto;
    }

    public PCGDto findIncludeDeleted(long pcgId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.findIncludeDeleted(pcgId);
        if (pcg == null) {
            return null;
        }
        PCGDto dto = PCGConvertUtil.convert(pcg);
        return dto;
    }

    public DubboResult<List<PCGCategoryDto>> findCategoryAll() {
        try {
            ArrayList PCGCategoryDtos = new ArrayList();
            List<PCGCategoryEntity> categorys = this.pCGCategoryGoodsService.findAll();
            ObjectUtil.convertList(categorys, PCGCategoryDtos, PCGCategoryDto.class);
            return DubboResult.successResult(PCGCategoryDtos);
        }
        catch (Exception e) {
            log.error("findCategoryAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGSellerDto>> findSellerAll() {
        try {
            ArrayList pCGSellerDtos = new ArrayList();
            List<PCGSellerEntity> sellers = this.pCGSellerGoodsService.findAll();
            ObjectUtil.convertList(sellers, pCGSellerDtos, PCGSellerDto.class);
            return DubboResult.successResult(pCGSellerDtos);
        }
        catch (Exception e) {
            log.error("findSellerAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<PCGCategorySellerGoodsDto>> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try {
            Page<PCGCategorySellerGoodsDto> page = this.pCGFilterConfigBO.findCategoryGoods(appId, categoryId, consumerId, consumerCredits, pageIndex, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            log.error("findCategoryGoods appId=" + appId + ",consumerId=" + consumerId + ",consumerCredits=" + consumerCredits + ",pageIndex=" + pageIndex + ",pageSize=" + pageSize, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<PCGCategorySellerGoodsDto>> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try {
            Page<PCGCategorySellerGoodsDto> page = this.pCGFilterConfigBO.findSellerGoods(appId, sellerId, consumerId, consumerCredits, pageIndex, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            log.error("findSellerGoods appId=" + appId + ",consumerId=" + consumerId + ",consumerCredits=" + consumerCredits + ",pageIndex=" + pageIndex + ",pageSize=" + pageSize, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId, Integer type) {
        try {
            List<Long> list = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, type);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findPCGFilterTargetIds appId=" + appId + ",type=" + type, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PCGCategorySellerGoodsDto> findSellerGoodsInfo(long appId, long gid, Long consumerId, Long consumerCredits) {
        try {
            PCGCategorySellerGoodsDto dto = this.pCGFilterConfigService.findSellerGoodsInfo(appId, gid, consumerId, consumerCredits);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findGoodsCouponInfo gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

