/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGGoodsService")
public class RemotePCGGoodsServiceImpl
implements RemotePCGGoodsService {
    private static final Logger log = LoggerFactory.getLogger(RemotePCGGoodsServiceImpl.class);
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private PCGFilterConfigService pcgFilterConfigService;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private PCGUtilBO pCGUtilBO;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> checkStockEnough(long pcgId, long appId, long consumerId) {
        try {
            DBTimeProfile.enter((String)"stock enough check");
            boolean enough = this.pCGUtilBO.checkStockEnough(pcgId, appId, consumerId);
            DubboResult dubboResult = DubboResult.successResult((Object)enough);
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> calcultePCGCredits(long pcgId, long appId, long consumerId) {
        try {
            DBTimeProfile.enter((String)"credits calculte");
            Long credits = this.pCGUtilBO.calcultePCGCredits(pcgId, appId, consumerId);
            DubboResult dubboResult = DubboResult.successResult((Object)credits);
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (pcg == null) {
            return DubboResult.failResult((String)"\u5546\u54c1\u5df2\u4e0b\u67b6(1)");
        }
        if (pcg.getDeleted().booleanValue()) {
            return DubboResult.failResult((String)"\u5546\u54c1\u5df2\u4e0b\u67b6(2)");
        }
        if (pcg.getPcgStatus() == 0) {
            return DubboResult.failResult((String)"\u5546\u54c1\u5df2\u4e0b\u67b6(3)");
        }
        if (this.pCGUtilBO.isInBlack(pcg, appId)) {
            return DubboResult.failResult((String)"\u5546\u54c1\u5df2\u4e0b\u67b6(4)");
        }
        if (pcg.getLimitPerConsumer() != null) {
            try {
                DBTimeProfile.enter((String)"user exchange limit check");
                int limit = pcg.getLimitPerConsumer();
                int count = this.goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
                if (count > limit) {
                    DubboResult dubboResult = DubboResult.failResult((String)"\u7528\u6237\u5df2\u5151\u6362");
                    return dubboResult;
                }
            }
            finally {
                DBTimeProfile.release();
            }
        }
        if (!((Boolean)this.checkStockEnough(pcgId, appId, consumerId).getResult()).booleanValue()) {
            return DubboResult.failResult((String)"\u5e93\u5b58\u4e0d\u8db3");
        }
        return DubboResult.successResult((Object)true);
    }

    public DubboResult<Long> takePlatformCouponGoods(long pcgId, long appId, long consumerId, String orderNum) {
        GoodsCouponEntity coupon;
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        DubboResult<Boolean> canTake = this.canTakePlatformCouponGoods(pcgId, appId, consumerId);
        if (!canTake.isSuccess() || !((Boolean)canTake.getResult()).booleanValue()) {
            return DubboResult.failResult((String)canTake.getMsg());
        }
        Integer dayLimit = null;
        GoodsDirectionalConfigEntity e = this.goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId);
        if (e != null && e.getDayLimit() != null) {
            dayLimit = e.getDayLimit();
        }
        if (dayLimit == null && (e = this.goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId)) != null && e.getDayLimit() != null) {
            dayLimit = e.getDayLimit();
        }
        if (dayLimit != null) {
            if (dayLimit <= 0) {
                return DubboResult.failResult((String)"\u5e93\u5b58\u4e0d\u8db3");
            }
            DubboResult ret = this.remoteSaleLimitService.addSaleToday(Integer.valueOf(1), pcgId + "", orderNum, dayLimit.intValue());
            if (!ret.isSuccess() || !((Boolean)ret.getResult()).booleanValue()) {
                return DubboResult.failResult((String)"\u5e93\u5b58\u4e0d\u8db3");
            }
        }
        if ((coupon = this.goodsCouponBO.takeCoupon(GoodsTypeEnum.PLATFORM, pcgId, consumerId, orderNum)) == null) {
            this.remoteSaleLimitService.rollbackSaleToday(Integer.valueOf(1), pcgId + "", orderNum);
            return DubboResult.failResult((String)"\u5151\u6362\u5931\u8d25");
        }
        if (pcg.getLimitPerConsumer() != null) {
            this.goodsLimitRecordService.addRecord(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
        }
        return DubboResult.successResult((Object)coupon.getGoodsCouponId());
    }

    public void rollbackPCGCoupon(long pcgId, long consumerId, long couponId, String orderNum) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        Boolean succ = this.goodsCouponBO.rollbackCoupon(couponId, orderNum);
        if (succ.booleanValue() && pcg.getLimitPerConsumer() != null) {
            this.goodsLimitRecordService.rollbackRecord(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
        }
    }
}

