/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsBatchServiceImpl
implements GoodsBatchService {
    private static Logger log = LoggerFactory.getLogger(GoodsBatchServiceImpl.class);
    @Autowired
    private GoodsBatchDao goodsBatchDao;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private GoodsCouponService goodsCouponService;

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Normal, startDay, endDay);
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Link, startDay, endDay);
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Repeat, startDay, endDay);
    }

    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchDao.selectNotDeletedNotExpiredGtypeGid(gtype, gid);
    }

    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchDao.selectNotDeletedByGtypeGid(gtype, gid);
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
        if (e.getImporting().booleanValue()) {
            return false;
        }
        int ret = this.goodsBatchDao.deleteBatch(gtype, gid, batchId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean fillStockId(GoodsTypeEnum gtype, long gid, long goodsBatchId, long stockId) {
        int ret = this.goodsBatchDao.updateStockId(gtype, gid, goodsBatchId, stockId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public GoodsBatchEntity find(Long goodsBatchId) {
        return this.goodsBatchDao.select(goodsBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)(this.getClass().getSimpleName() + ".refreshBatchUsing"));
            List<GoodsBatchEntity> batchs = this.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity e : batchs) {
                long stock = this.goodsCouponService.findNotUsedCount(e);
                if (stock > 0L) continue;
                this.goodsBatchDao.updateStatusUsed(e.getId());
            }
            batchs = this.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 1) continue;
                backups.add(e);
                if (min == null) {
                    min = e.getStartDay();
                    continue;
                }
                if (min.getTime() <= e.getStartDay().getTime()) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.goodsBatchDao.updateStatusUsing(e.getId());
                GoodsBatchEntity goodsBatchEntity = this.find(e.getId());
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Long getOrigionTotalBatchStock(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        GoodsBatchEntity batch = this.goodsBatchDao.select(goodsBatchId);
        if (batch.getBatchType() == 1 || batch.getBatchType() == 2) {
            if (batch.getStockId() == null) {
                return 0L;
            }
            DubboResult ret = this.remoteStockBackendService.findTotalStock(batch.getStockId().longValue());
            if (ret.isSuccess()) {
                return (Long)ret.getResult();
            }
            throw new RuntimeGoodsException(ErrorCode.E0203003);
        }
        return this.goodsCouponService.findTotalAllCount(gtype, gid, goodsBatchId);
    }

    @Override
    public Long getSumBatchStock(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> list = this.findNormalBatchs(gtype, gid);
        long total = 0L;
        for (GoodsBatchEntity e : list) {
            if (e.getStatus() == 4) continue;
            total += this.goodsCouponService.findNotUsedCount(e);
        }
        return total;
    }

    @Override
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> list = this.findNormalBatchs(gtype, gid);
        long total = 0L;
        for (GoodsBatchEntity e : list) {
            if (e.getStatus() == 4) continue;
            total += this.getOrigionTotalBatchStock(gtype, gid, e.getId()).longValue();
        }
        return total;
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        this.goodsBatchDao.updateStatusUsed(batchId);
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        this.goodsBatchDao.updateStatusUsing(batchId);
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        this.goodsBatchDao.updateStatusNotUsed(batchId);
    }
}

