/**
 * Project Name:goods-center-biz
 * File Name:ItemDO.java
 * Package Name:cn.com.duiba.goods.center.biz.entity
 * Date:2016年6月20日上午11:32:00
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.entity;

import java.util.Date;

/**
 * ClassName:ItemDO <br/>
 * Date:     2016年6月20日 上午11:32:00 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ItemEntity {
        /**主键id*/
private Long id;
    /**/
    private String tag;
    /**商品名称*/
    private String name;
    /**商品副标题*/
    private String subtitle; // 副标题
    /**商品logo图*/
    private String logo;
    /**商品主图*/
    private String image;
    /**详情多图展示*/
    private String multiImage; // 详情多图展示
    /**默认兑换价等值积分(根据汇率兑换为实际积分)*/
    private Integer facePrice;//默认兑换价等值积分(根据汇率兑换为实际积分)
    /**市场价*/
    private Integer marketPrice;//市场价
    /**实际收费价格，单位分*/
    private Integer actualPrice;
    /**最小兑换积分(此字段已经弃用)*/
    private Long minCredits;// 最小兑换积分(此字段已经弃用)
    /**最小兑换面值*/
    private Integer minFacePrice;
    /**详情描述*/
    private String description;
    /**强调下载*/
    private Boolean suggestDownload;//强调下载
    /**iOS打开应用连接*/
    private String iosOpen; //iOS打开应用连接
    /**iOS下载连接*/
    private String iosDownload;
    /**安卓下载连接*/
    private String androidDownload;
    /**启用停用*/
    private Boolean enable; // 启用停用
    /**剩余库存*/
    private Integer remaining; // 剩余票数
    /**销量*/
    private Integer sales; // 销量
    /**管理员排序 目前自动推荐功能在用*/
    private Integer payload; // 管理员排序 目前自动推荐功能在用
    /**
     * 用户自定义商品价格（可分为1-6栏显示，存储结构为json形式的字符串
     * 面值1:积分1,面值2:积分2...）
     *
     */
    private String customPrice; // 用户自定义商品价格（可分为1-6栏显示，存储结构为json形式的字符串，
                                // 面值1:积分1,面值2:积分2...）
    /**布局2使用的小图*/
    private String smallImage; // 布局2使用的小图
    /**白底缩略图*/
    private String whiteImage;//白底缩略图
    /**兑换次数限制*/
    private Integer limitCount; // 兑换次数限制
    /**兑换限制作用域：永久/每天*/
    private String limitScope; // 兑换限制作用域：永久/每天
    /**商品类型，比如 QB，话费充值 等等*/
    private String type; // 商品类型，比如 QB，话费充值 等等
    /**商品类型 Gtype*/
    private Integer typeInt;
    /**兑换提示模板 实物用于 兑换成功文案*/
    private String exchangeTipTemplate; // 兑换提示模板 实物用于 兑换成功文案
    /**App专属商品*/
    private Long ownerAppId; // App专属商品
    /**优惠券批次*/
    private Long batchId; // 优惠券批次
    /**优惠券批次*/
    private Long itemClassifyId; // 优惠券批次
    /**有效期开始时间*/
    private Date validStartDate;// 有效期开始时间
    /**有效期结束时间 实物用于下架时间*/
    private Date validEndDate; // 有效期结束时间 实物用于下架时间
    /**启用时间*/
    private Date publishTime;// 启用时间
    /**是否已经删除*/
    private Boolean deleted;// 是否已经删除
    /**商品费率*/
    private String productPrice; // 商品费率
    /**暂不可用 直充类使用*/
    private Boolean shutDown;// 暂不可用 直充类使用
                                        // 开启后前台界面的按钮将展示为“暂不可用”，充值系统故障时打开
    /**是否展示警示区*/
    private Boolean showAlert; // 是否展示警示区
    /**警示文案 实物用于发货后文案*/
    private String alertMessage;// 警示文案 实物用于发货后文案
    /***/
    private Integer duibaType; // 兑吧特殊类型 0表示普通兑吧商品，其它数值为各活动专用的商品，对开发者不可见。
    /***/
    private Boolean autoRecommend;// 自动推荐标示，目前只支持免费的兑换项 ：优惠券 实物 停用的兑换项
                                            // 不能开启自动推荐
    /***/
    private Integer subType; // 优惠券类型，目前只给优惠券使用 0-普通类型 1-链接类型 2--可重复类型
    /***/
    private String bannerImage;// banner图片
    /***/
    private Date gmtCreate;
    /***/
    private Date gmtModified;
    /***/
    private Integer operationsType; //商品类型  移位运算 第0位：限时商品   第1位：限量商品  第2位：是否运营商品
    /***/
    private String  limitTimeBetween;       //每日限时区间
    /***/
    private Integer limitEverydayQuantity;      //每日限制销量
    /***/
    private String  limitDate; //兑换日期限制
    /***/
    private Integer sourceType; // 来源类型，目前有 普通兑换类型，单品抽奖类型
    /***/
    private Long sourceRelationId;
    /***/
    private Date autoOffDate; //定时自动下架日期
    /***/
    private transient String name4Admin;
    
    /***/
    private Long    salePrice   ;// 兑换价格
    /***/
    private String  expressType ;// 运费类型        free包邮，unify统一运费，template运费模板
    /***/
    private Long    expressPrice    ;// 运费价格
    /***/
    private Long    expressTemplateId   ;//                     
    
    /**added zhengjy 20160524  安全链接 begin*/
    private Long sellerId;//商家ID
    /**added zhengjy 20160524  安全链接 end*/

    /** */
    /**
     *
     * @author xuhengfei
     * @param key key
     * @param value value 
     * @param form form
     * @since JDK 1.6
     */
    public void setExInfo(String key,String value,String form){
        
    }
    /**
     * 授予某个位运算的值为1
     *
     * @author xuhengfei
     * @param opType opType
     * @since JDK 1.6
     */
    public void grantOpTypeItem(int opType){
        int v=1<<opType;
        operationsType=operationsType | v;
    }
    /**
     * 授予某个位运算的值为0
     *
     * @author xuhengfei
     * @param opType opType
     * @since JDK 1.6
     */
    public void ungrantOpTypeItem(int opType){
        int v=1<<opType;
        v=~v;
        operationsType=operationsType & v;
    }
    /**
     * 判断某个位运算上是否为1
     *
     * @author xuhengfei
     * @param opType opType
     * @return 
     * @since JDK 1.6
     */
    public boolean isOpTypeItem(int opType){
        int v=1<<opType;
        int ret= operationsType & v;
        return ret!=0;
    }
    
    public Long getItemClassifyId() {
        return itemClassifyId;
    }

    public void setItemClassifyId(Long itemClassifyId) {
        this.itemClassifyId = itemClassifyId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }
    
    
    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }
    
    public Long getMinCredits() {
        return minCredits;
    }

    public void setMinCredits(Long minCredits) {
        this.minCredits = minCredits;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getMultiImage() {
        return multiImage;
    }

    public void setMultiImage(String multiImage) {
        this.multiImage = multiImage;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Integer marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Integer getMinFacePrice() {
        return minFacePrice;
    }

    public void setMinFacePrice(Integer minFacePrice) {
        this.minFacePrice = minFacePrice;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIosDownload() {
        return iosDownload;
    }

    public void setIosDownload(String iosDownload) {
        this.iosDownload = iosDownload;
    }

    public String getAndroidDownload() {
        return androidDownload;
    }

    public void setAndroidDownload(String androidDownload) {
        this.androidDownload = androidDownload;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }

    public Integer getSales() {
        return sales;
    }

    public void setSales(Integer sales) {
        this.sales = sales;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public String getCustomPrice() {
        return customPrice;
    }

    public void setCustomPrice(String customPrice) {
        this.customPrice = customPrice;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getTypeInt() {
        return typeInt;
    }

    public void setTypeInt(Integer typeInt) {
        this.typeInt = typeInt;
    }

    public String getExchangeTipTemplate() {
        return exchangeTipTemplate;
    }

    public void setExchangeTipTemplate(String exchangeTipTemplate) {
        this.exchangeTipTemplate = exchangeTipTemplate;
    }

    public Long getOwnerAppId() {
        return ownerAppId;
    }

    public void setOwnerAppId(Long ownerAppId) {
        this.ownerAppId = ownerAppId;
    }

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(String productPrice) {
        this.productPrice = productPrice;
    }

    public Boolean getShutDown() {
        return shutDown;
    }

    public void setShutDown(Boolean shutDown) {
        this.shutDown = shutDown;
    }

    public Boolean getShowAlert() {
        return showAlert;
    }

    public void setShowAlert(Boolean showAlert) {
        this.showAlert = showAlert;
    }

    public String getAlertMessage() {
        return alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public Integer getDuibaType() {
        return duibaType;
    }

    public void setDuibaType(Integer duibaType) {
        this.duibaType = duibaType;
    }

    public Boolean getAutoRecommend() {
        return autoRecommend;
    }

    public void setAutoRecommend(Boolean autoRecommend) {
        this.autoRecommend = autoRecommend;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getOperationsType() {
        return operationsType;
    }

    public void setOperationsType(Integer operationsType) {
        this.operationsType = operationsType;
    }

    public String getLimitTimeBetween() {
        return limitTimeBetween;
    }

    public void setLimitTimeBetween(String limitTimeBetween) {
        this.limitTimeBetween = limitTimeBetween;
    }

    public Integer getLimitEverydayQuantity() {
        return limitEverydayQuantity;
    }

    public void setLimitEverydayQuantity(Integer limitEverydayQuantity) {
        this.limitEverydayQuantity = limitEverydayQuantity;
    }

    public Boolean getSuggestDownload() {
        return suggestDownload;
    }

    public void setSuggestDownload(Boolean suggestDownload) {
        this.suggestDownload = suggestDownload;
    }

    public String getIosOpen() {
        return iosOpen;
    }

    public void setIosOpen(String iosOpen) {
        this.iosOpen = iosOpen;
    }


    public String getName4Admin() {
        return name4Admin;
    }

    public void setName4Admin(String name4Admin) {
        this.name4Admin = name4Admin;
    }

    public String getLimitDate() {
        return limitDate;
    }

    public void setLimitDate(String limitDate) {
        this.limitDate = limitDate;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public String getWhiteImage() {
        return whiteImage;
    }

    public void setWhiteImage(String whiteImage) {
        this.whiteImage = whiteImage;
    }

    public Long getSalePrice(){
        return salePrice;
    }

    public void setSalePrice(Long salePrice){
        this.salePrice = salePrice;
    }

    public String getExpressType(){
        return expressType;
    }

    public void setExpressType(String expressType){
        this.expressType = expressType;
    }

    public Long getExpressPrice(){
        return expressPrice;
    }

    public void setExpressPrice(Long expressPrice){
        this.expressPrice = expressPrice;
    }

    public Long getExpressTemplateId(){
        return expressTemplateId;
    }

    public void setExpressTemplateId(Long expressTemplateId){
        this.expressTemplateId = expressTemplateId;
    }

}

