
/**
 * Project Name:goods-center-biz
 * File Name:RemoteItemQueryBackendServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.custom
 * Date:2016年6月20日上午11:30:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.custom;


import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.custom.RemoteItemQueryBackendService;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.SimpleItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ClassName:RemoteItemQueryBackendServiceImpl <br/>
 * Date:     2016年6月20日 上午11:30:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remoteItemQueryBackendService")
public class RemoteItemQueryBackendServiceImpl implements RemoteItemQueryBackendService{
    @Autowired
    private SimpleItemService simpleItemService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    
    @Override
    public String findGoodsTitle(GoodsTypeEnum gtype, Long gid) {
        if(gtype==GoodsTypeEnum.DUIBA){
            return simpleItemService.find(gid).getName();
        }else if(gtype==GoodsTypeEnum.APP){
            return null;//暂不支持
        }else if(gtype==GoodsTypeEnum.PLATFORM){
            PlatformCouponGoodsEntity e=platformCouponGoodsService.find(gid);
            return e.getTitle();
        }
        return null;
    }

}

