/**
 * Project Name:goods-center-biz
 * File Name:GoodsCenterConfigServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年6月3日上午9:48:01
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.dao.GoodsCenterConfigDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCenterConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCenterConfigService;

/**
 * ClassName:GoodsCenterConfigServiceImpl <br/>
 * Date:     2016年6月3日 上午9:48:01 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("goodsCenterConfigService")
public class GoodsCenterConfigServiceImpl implements GoodsCenterConfigService{
    @Autowired
    private GoodsCenterConfigDao goodsCenterConfigDao;
    @Override
    public List<String> findHomeImages() {
        GoodsCenterConfigEntity e=goodsCenterConfigDao.selectByType(GoodsCenterConfigEntity.TypeHomeImages);
        if(e==null){
            return new ArrayList<>();
        }
        String[] ss=e.getContent().split("\\|");
        List<String> ret=new ArrayList<>();
        ret.add(ss[0]);
        ret.add(ss[1]);
        return ret;
    }

    @Override
    public void updateHomeImages(String logoImage, String bannerImage) {
        String content=logoImage+"|"+bannerImage;
        GoodsCenterConfigEntity e=goodsCenterConfigDao.selectByType(GoodsCenterConfigEntity.TypeHomeImages);
        if(e==null){
            goodsCenterConfigDao.insert(GoodsCenterConfigEntity.TypeHomeImages, content);
        }else{
            goodsCenterConfigDao.update(GoodsCenterConfigEntity.TypeHomeImages, content);
        }
    }

}

