/**
 * Project Name:goods-center-biz
 * File Name:StockServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.stock.impl
 * Date:2016年6月28日下午2:46:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;

/**
 * ClassName:StockServiceImpl <br/>
 * Date:     2016年6月28日 下午2:46:30 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("stockService")
public class StockServiceImpl implements StockService{
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    
    @Override
    public List<Long> getNeedCountDownOtherStockIds(int gtype, long gid,long appId) {
        if(gtype==GoodsTypeEnum.PLATFORM.getGtype()){
            List<Long> stockIds=new ArrayList<>();
            //定向APP 库存ID 查询
            GoodsDirectionalConfigEntity config=goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.getGoodsTypeEnum(gtype), gid, appId);
            if(config==null){
                config=goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.getGoodsTypeEnum(gtype), gid);
                if(config!=null){
                    //定向共享库存
                    stockIds.add(config.getStockId());
                }
            }else{
                //定向库存
                stockIds.add(config.getStockId());
            }
            return stockIds;
        }else{
            //其他类型暂不支持
            return new ArrayList<>();
        }
    }

}

