package cn.com.duiba.goods.center.biz.util;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.ObjectMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * This sample demonstrates how to upload an object by append mode 
 * to Aliyun OSS using the OSS SDK for Java.
 */
@Component
public class AppendUploadUtil {

    private static final Logger LOG = LoggerFactory.getLogger(AppendUploadUtil.class);

    @Value("${goods.oss.endPoint}")
    private String endpoint;
    @Value("${goods.oss.accessId}")
    private String accessKeyId;
    @Value("${goods.oss.accessKey}")
    private String accessKeySecret;

    @Value("${goods.oss.bucketName}")
    private String bucketName;


    private String key;


    public Long upload(String content , Long position) throws  IOException {
        /*
         * Constructs a client instance with your account for accessing OSS
         */
        OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        AppendObjectResult appendObjectResult = null;
        try {

            // 创建上传Object的Metadata
            ObjectMetadata meta = new ObjectMetadata();
            // 设置上传内容类型
            meta.setContentType("application/octet-stream");

            InputStream instream = new ByteArrayInputStream(content.getBytes());
            appendObjectResult = client.appendObject(
                    new AppendObjectRequest(bucketName, key, instream,meta).withPosition(position));


//            appendObjectResult = client.appendObject(
//                    new AppendObjectRequest(bucketName,key,file,meta)
//                            .withPosition(position));



            LOG.info("\tNext position=" + appendObjectResult.getNextPosition() +
                    ", CRC64=" + appendObjectResult.getObjectCRC64() + "\n");


        } catch (OSSException oe) {
            LOG.error("Caught an OSSException, which means your request made it to OSS, "
                    + "but was rejected with an error response for some reason.");
            LOG.error("Error Message: " + oe.getErrorCode());
            LOG.error("Error Code:       " + oe.getErrorCode());
            LOG.error("Request ID:      " + oe.getRequestId());
            LOG.error("Host ID:           " + oe.getHostId());
        } catch (ClientException ce) {
            LOG.error("Caught an ClientException, which means the client encountered "
                    + "a serious internal problem while trying to communicate with OSS, "
                    + "such as not being able to access the network.");
            LOG.error("Error Message: " + ce.getMessage());
        } finally {
            /*
             * Do not forget to shut down the client finally to release all allocated resources.
             */
            client.shutdown();
        }
        return appendObjectResult.getNextPosition();
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}