/**
 * Project Name:goods-center-biz
 * File Name:PCGConvertUtil.java
 * Package Name:cn.com.duiba.goods.center.biz.util
 * Date:2016年5月19日下午7:48:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.util;

import java.util.ArrayList;
import java.util.List;

import net.sf.cglib.beans.BeanCopier;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PCGConvertUtil <br/>
 * Function: PCG 的 DTO转换工具类 <br/>
 * Date:     2016年5月19日 下午7:48:36 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class PCGConvertUtil {
    private static BeanCopier goodsCouponParser=BeanCopier.create(GoodsCouponDto.class, GoodsCouponEntity.class, false);
    private static BeanCopier goodsCouponCopier=BeanCopier.create(GoodsCouponEntity.class, GoodsCouponDto.class, false);
    
    public static GoodsCouponDto convert(GoodsCouponEntity entity){
        GoodsCouponDto dto=new GoodsCouponDto();
        goodsCouponCopier.copy(entity, dto, null);
        return dto;
    }
    
    public static GoodsCouponEntity parse(GoodsCouponDto dto){
        GoodsCouponEntity entity=new GoodsCouponEntity();
        goodsCouponParser.copy(dto, entity, null);
        return entity;
    }
    
    
    private static BeanCopier parser=BeanCopier.create(PCGDto.class, PlatformCouponGoodsEntity.class, false);
    public static PlatformCouponGoodsEntity parse(PCGDto dto){
        PlatformCouponGoodsEntity entity=new PlatformCouponGoodsEntity();
        parser.copy(dto, entity, null);
        return entity;
    }

    private static BeanCopier copier=BeanCopier.create(PlatformCouponGoodsEntity.class, PCGDto.class, false);
    public static PCGDto convert(PlatformCouponGoodsEntity entity){
        PCGDto dto=new PCGDto();
        copier.copy(entity, dto, null);
        return dto;
    }
    
    public static List<PCGDto> convert(List<PlatformCouponGoodsEntity> list){
        List<PCGDto> ret=new ArrayList<>();
        for(PlatformCouponGoodsEntity entity:list){
            ret.add(convert(entity));
        }
        return ret;
    }

}

