/**
 * Project Name:goods-center-biz
 * File Name:GoodsLimitRecordDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月28日上午11:17:47
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsLimitRecordDao;
import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;

/**
 * ClassName:GoodsLimitRecordDaoImpl <br/>
 * Date:     2016年6月28日 上午11:17:47 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsLimitRecordDao")
public class GoodsLimitRecordDaoImpl extends BaseDao implements GoodsLimitRecordDao{

    @Override
    public GoodsLimitRecordEntity selectByCondition(int gtype, long gid, long consumerId) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype",gtype);
        params.put("gid", gid);
        params.put("consumerId", consumerId);
        return getSqlSession().selectOne(getStamentNameSpace("selectByCondition"),params);
    }

    @Override
    public int insertRecord(int gtype, long gid, long consumerId) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype",gtype);
        params.put("gid", gid);
        params.put("consumerId", consumerId);
        params.put("count", 1);
        return getSqlSession().insert(getStamentNameSpace("insertRecord"), params);
    }

    @Override
    public int updateIncreament(int gtype, long gid, long consumerId) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype",gtype);
        params.put("gid", gid);
        params.put("consumerId", consumerId);
        return getSqlSession().update(getStamentNameSpace("updateIncreament"), params);
    }

    @Override
    public int updateRollback(int gtype, long gid, long consumerId) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype",gtype);
        params.put("gid", gid);
        params.put("consumerId", consumerId);
        return getSqlSession().update(getStamentNameSpace("updateRollback"), params);
    }

	@Override
	public List<GoodsLimitRecordEntity> selectCounts(int gtype,List<Long> gids, long consumerId) {
		Map<String, Object> params=new HashMap<String, Object>();
        params.put("gtype",gtype);
        params.put("gids", gids);
        params.put("consumerId", consumerId);
		return getSqlSession().selectList(getStamentNameSpace("selectCounts"),params);
	}

}

