package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodCouponRetrieveLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsBatchService;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponRetrieveLogService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("remoteGoodsBatchService")
public class RemoteGoodsBatchServiceImpl implements RemoteGoodsBatchService{
	private static Logger log=LoggerFactory.getLogger(RemoteGoodsBatchServiceImpl.class);
	@Autowired
	private GoodsBatchService goodsBatchService;
	@Autowired
	private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;

	@Autowired
	private GoodsCouponService goodsCouponService;
	@Autowired
	private GoodsCouponRetrieveLogService goodsCouponRetrieveLogService;
	
	@Override
	public DubboResult<Map<Long, List<GoodsBatchDto>>> findGoodsBatchs(GoodsTypeEnum gtype,List<Long> gids) {
		try{
			List<GoodsBatchEntity> retList = goodsBatchService.findGoodsBatchs(gtype,gids);
			List<GoodsBatchDto> batchs = new ArrayList<GoodsBatchDto>();
			ObjectUtil.convertList(retList, batchs,GoodsBatchDto.class);
			List<GoodsBatchDto> newList = new ArrayList<GoodsBatchDto>();
			Map<Long,List<GoodsBatchDto>> map = new HashMap<Long,List<GoodsBatchDto>>();
			for(GoodsBatchDto gb: batchs){
				List<GoodsBatchDto> l  = map.get(gb.getGid());
				if(l==null){
					l = new ArrayList<GoodsBatchDto>();
					map.put(gb.getGid(), l);
				}
				l.add(gb);
			}
			return DubboResult.successResult(map);
		}catch(Exception e){
			log.error("findGoodsBatchs error",e);
			return DubboResult.failResult(e.getMessage());
		}
		
	}

	@Override
	public DubboResult<List<GoodsBatchDto>> findGoodsBatch(GoodsTypeEnum gtype,
			Long gid) {
		try {
            List<GoodsBatchDto> ret = goodsBatchCouponBackendBO.findBatchs(gtype, gid);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findGoodsBatch gtype=" + gtype + ",gid=" + gid, e);
            return DubboResult.failResult(e.getMessage());
        }
	}

	/**
	 *  
	 *      * 回收某个商品某个批次的券码<br/>
	 *  
	 *      *
	 *  
	 *      * @author zhujianda
	 *  
	 *      * @param gtype 商品类型
	 *  
	 *      * @param gid 商品id
	 *  
	 *      * @param batchId 批次id
	 *  
	 *      * @param dstQuantity 欲回收的券的数量
	 *  
	 *      * @return 结果集
	 *  
	 *      * @since JDK 1.7
	 *  
	 *
	 * @param gtype 商品类型
	 * @param gid	商品id
	 * @param batchId 批次id
	 * @param dstQuantity 回收数量
	 */
	@Override
	public DubboResult<Long> retrieveGoodsBatch(GoodsTypeEnum gtype, Long gid, Long batchId, Long dstQuantity) {
		try {
			Long count = goodsBatchService.retrieveGoodsBatch(gtype,gid,batchId,dstQuantity);
			return DubboResult.successResult(count);
		} catch (Exception e) {
			return DubboResult.failResult(e.getMessage());
		}
	}



	/**
	 *  
	 *      * 查询回收结果<br/>
	 *  
	 *      *
	 *  
	 *      * @author zhujianda
	 *  
	 *      * @param gtype 商品类型
	 *  
	 *      * @param gid 商品id
	 *  
	 *      * @param batchId 批次id
	 *  
	 *      * @return 结果集
	 *  
	 *      * @since JDK 1.7
	 *  
	 *      
	 *
	 * @param gtype
	 * @param gid
	 * @param batchId
	 */

	public DubboResult<GoodCouponRetrieveLogDto> queryRetrieveRet(Long id) {
		try {
			GoodCouponRetrieveLogDto ret = goodsCouponRetrieveLogService.find(id);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			return DubboResult.failResult(e.getMessage());
		}
	}


}
