/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年5月27日下午1:13:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:PlatformCouponGoodsServiceImpl <br/>
 * Date:     2016年5月27日 下午1:13:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("platformCouponGoodsService")
public class PlatformCouponGoodsServiceImpl implements PlatformCouponGoodsService{
    @Autowired
    private PlatformCouponGoodsDao platformCouponGoodsDao;
    @Autowired
    private RemoteIDMakerService remoteIDMakerService;
    @Autowired
    private PCGSellerGoodsService pcgSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pcgCategoryGoodsService;
    @Autowired
	private RedisTemplate<String, String> redisTemplate;
    
    @Override
    public PlatformCouponGoodsEntity find(long pcgId) {
        return platformCouponGoodsDao.selectByPcgId(pcgId);
    }
    @Override
    public PlatformCouponGoodsEntity findIncludeDeleted(long pcgId) {
        return platformCouponGoodsDao.selectByPcgIdIncludeDeleted(pcgId);
    }
    @Override
    public Map<Long, PlatformCouponGoodsEntity> findByIds(List<Long> pcgIds) {
        
        List<PlatformCouponGoodsEntity> list=platformCouponGoodsDao.selectByIds(pcgIds);
        Map<Long, PlatformCouponGoodsEntity> map=new HashMap<Long, PlatformCouponGoodsEntity>();
        for(PlatformCouponGoodsEntity e:list){
            map.put(e.getPcgId(), e);
        }
        return map;
    }
    @Override
    public Long createPlatformCouponGoods(PCGInsertDto goods) {
        DubboResult<Long> ret=remoteIDMakerService.getNextID(IDMakerTypeEnums.GOODS.getType());
        if(ret.isSuccess()){
            goods.setPcgId(ret.getResult());
            platformCouponGoodsDao.insert(goods);
            return ret.getResult();
        }else{
            throw new RuntimeGoodsException(ErrorCode.E0203002);
        }
    }

    @Override
    public void editPlatformCouponGoods(Long pcgId, PCGEditDto goods) {
        platformCouponGoodsDao.updateEditGoods(pcgId,goods);
        RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getPlatformRedisKey(String.valueOf(pcgId)));
    }
    
    @Override
    public boolean editPlatformCouponType(Long pcgId, int couponType) {
        int ret=platformCouponGoodsDao.updateCouponType(pcgId, couponType);
        //清除商品信息缓存
        RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getPlatformRedisKey(String.valueOf(pcgId)));
        if(ret==1){
            return true;
        }else{
            return false;
        }
        
    }
   

    @Override
    public void onshelfGoods(Long pcgId) {
        platformCouponGoodsDao.updateStatusOnShelf(pcgId);
    }
    
    @Override
    @Transactional("pcg")
    public void offshelfGoods(Long pcgId) {
        platformCouponGoodsDao.updateStatusOffShelf(pcgId);
        pcgSellerGoodsService.deleteAllByPcgId(pcgId);
        pcgCategoryGoodsService.deleteAllByPcgId(pcgId);
        //清除商品信息缓存
        RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getPlatformRedisKey(String.valueOf(pcgId)));
        
        
    }
    
    @Override
    @Transactional("pcg")
    public void deleteGoods(Long pcgId) {
        platformCouponGoodsDao.markDelete(pcgId);
        pcgSellerGoodsService.deleteAllByPcgId(pcgId);
        pcgCategoryGoodsService.deleteAllByPcgId(pcgId);
        //清除商品信息缓存
        RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getPlatformRedisKey(String.valueOf(pcgId)));
    }

    @Override
    public List<PlatformCouponGoodsEntity> searchByName(String name) {
        return platformCouponGoodsDao.selectSearchByName(name);
    }
    
    @Override
    public Page<PlatformCouponGoodsEntity> findPage(String name, Integer pcgStatus, int pageSize, int pageIndex) {
        int start=pageSize*(pageIndex-1);
        int limit=pageSize;
                
        
        int total=platformCouponGoodsDao.selectCountBySearch(name, pcgStatus);
        List<PlatformCouponGoodsEntity> list=platformCouponGoodsDao.selectBySearch(name, pcgStatus, start, limit);
        Page<PlatformCouponGoodsEntity> page=new Page<>(pageSize, pageIndex);
        page.setList(list);
        page.setTotalCount(total);
        page.setTotalPages(total%pageSize==0?total/pageSize:(total/pageSize+1));
        return page;
        
    }
    @Override
    public void editPCGSwitches(Long pcgId, Long switches) {
    	//清除商品信息缓存
        RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getPlatformRedisKey(String.valueOf(pcgId)));
        this.platformCouponGoodsDao.updateSwitches(pcgId, switches);
    }

}

