/**
 * Project Name:goods-center-biz File Name:GoodsBatchDaoImpl.java Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月23日下午12:04:12 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName:GoodsBatchDaoImpl <br/>
 * Date: 2016年5月23日 下午12:04:12 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("goodsBatchDao")
public class GoodsBatchDaoImpl extends BaseDao implements GoodsBatchDao {

    private Logger log = LoggerFactory.getLogger(GoodsBatchDaoImpl.class);

    @Override
    public Long insert(GoodsTypeEnum gtype, Long gid, CouponType batchType, Date startDay, Date endDay, Long stockId) {

        GoodsBatchEntity entity = new GoodsBatchEntity();
        entity.setGtype(gtype.getGtype());
        entity.setGid(gid);
        entity.setBatchType(batchType.getValue());
        entity.setStartDay(startDay);
        entity.setEndDay(endDay);
        entity.setStatus(GoodsBatchEntity.StatusNotUse);
        entity.setImporting(false);
        entity.setStockId(stockId);

        getSqlSession().insert(getStamentNameSpace("insert"), entity);

        return entity.getId();
    }

    @Override
    public GoodsBatchEntity select(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"), id);
    }

    @Override
    public List<GoodsBatchEntity> selectNotDeletedByGtypeGid(GoodsTypeEnum gtype, long gid) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        return getSqlSession().selectList(getStamentNameSpace("selectNotDeletedByGtypeGid"), params);
    }

    @Override
    public List<GoodsBatchEntity> selectNotDeletedNotExpiredGtypeGid(GoodsTypeEnum gtype, long gid) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);

        return getSqlSession().selectList(getStamentNameSpace("selectNotDeletedNotExpiredGtypeGid"), params);
    }

    @Override
    public void updateImportingYes(Long id) {
        getSqlSession().update(getStamentNameSpace("updateImportingYes"), id);

    }

    @Override
    public void updateImportingNo(Long id) {
        getSqlSession().update(getStamentNameSpace("updateImportingNo"), id);
    }

    @Override
    public int deleteBatch(GoodsTypeEnum gtype, long gid, Long goodsBatchId) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return getSqlSession().update(getStamentNameSpace("deleteBatch"), params);
    }

    @Override
    public int updateStockId(GoodsTypeEnum gtype, long gid, Long goodsBatchId, Long stockId) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("stockId", stockId);
        return getSqlSession().update(getStamentNameSpace("updateStockId"), params);
    }

    @Override
    public int updateStatusUsed(Long id) {
        return getSqlSession().update(getStamentNameSpace("updateStatusUsed"), id);
    }

    @Override
    public int updateStatusUsing(Long id) {
        return getSqlSession().update(getStamentNameSpace("updateStatusUsing"), id);
    }

    @Override
    public int updateStatusNotUsed(Long id) {
        return getSqlSession().update(getStamentNameSpace("updateStatusNotUsed"), id);
    }

    @Override
    public int updateValidDate(long id, Date startDay, Date endDay) {
        Map<String, Object> params = getBlankParams();
        params.put("id", id);
        params.put("startDay", startDay);
        params.put("endDay", endDay);

        return getSqlSession().update(getStamentNameSpace("updateValidDate"), params);
    }

    @Override
    public int updateBatchType(long gid, int dstType) {
        Map<String, Object> params = getBlankParams();
        params.put("gid", gid);
        params.put("dstType", dstType);

        return getSqlSession().update(getStamentNameSpace("updateGoodsType"), params);
    }

    @Override
    public int physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("batchId", batchId);

        return getSqlSession().delete(getStamentNameSpace("physicalDeleteBatch"), params);
    }

    @Override
    public List<GoodsBatchEntity> selectGoodsBatchs(GoodsTypeEnum gtype,
                                                    List<Long> gids) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype.getGtype());
        params.put("gids", gids);
        return getSqlSession().selectList(getStamentNameSpace("selectGoodsBatchs"), params);
    }

    @Override
    public List<GoodsBatchEntity> findAllNormalStockIsNull() {
        return getSqlSession().selectList(getStamentNameSpace("findAllNormalStockIsNull"));
    }
}

