package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsTagsDao;
import cn.com.duiba.goods.center.biz.entity.GoodsTagsEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by gyf .
 * 16/9/1 .
 */
@Repository("goodsTagsDao")
public class GoodsTagsDaoImpl extends BaseDao implements GoodsTagsDao {

    @Override
    public int insert(GoodsTagsEntity entity) {
        return getSqlSession().insert(getStamentNameSpace("insert"), entity);
    }

    @Override
    public GoodsTagsEntity selectByGidAndGtype(Integer gtype, Long gid) {
        Map<String, Object> params=getBlankParams();
        params.put("gtype", gtype);
        params.put("gid", gid);
        return getSqlSession().selectOne(getStamentNameSpace("selectByGidAndGtype"), params);
    }

    @Override
    public int updateTagsById(Long id, String tags) {
        Map<String, Object> params = getBlankParams();
        params.put("id", id);
        params.put("tags", tags);
        return getSqlSession().update(getStamentNameSpace("updateTagsById"), params);
    }

    @Override
    public List<GoodsTagsEntity> selectByGtypeAndGids(Integer gtype, List<Long> gids) {
        Map<String, Object> params = getBlankParams();
        params.put("gtype", gtype);
        params.put("gids", gids);
        return getSqlSession().selectList(getStamentNameSpace("selectByGtypeAndGids"), params);
    }
}
