/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodCouponRetrieveLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsBatchService;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponRetrieveLogService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsBatchService")
public class RemoteGoodsBatchServiceImpl
implements RemoteGoodsBatchService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsBatchServiceImpl.class);
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsCouponRetrieveLogService goodsCouponRetrieveLogService;

    public DubboResult<Map<Long, List<GoodsBatchDto>>> findGoodsBatchs(GoodsTypeEnum gtype, List<Long> gids) {
        try {
            List<GoodsBatchEntity> retList = this.goodsBatchService.findGoodsBatchs(gtype, gids);
            ArrayList batchs = new ArrayList();
            ObjectUtil.convertList(retList, batchs, GoodsBatchDto.class);
            ArrayList newList = new ArrayList();
            HashMap<Long, ArrayList<GoodsBatchDto>> map = new HashMap<Long, ArrayList<GoodsBatchDto>>();
            for (GoodsBatchDto gb : batchs) {
                ArrayList<GoodsBatchDto> l = (ArrayList<GoodsBatchDto>)map.get(gb.getGid());
                if (l == null) {
                    l = new ArrayList<GoodsBatchDto>();
                    map.put(gb.getGid(), l);
                }
                l.add(gb);
            }
            return DubboResult.successResult(map);
        }
        catch (Exception e) {
            log.error("findGoodsBatchs error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsBatchDto>> findGoodsBatch(GoodsTypeEnum gtype, Long gid) {
        try {
            List<GoodsBatchDto> ret = this.goodsBatchCouponBackendBO.findBatchs(gtype, gid);
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findGoodsBatch gtype=" + gtype + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> retrieveGoodsBatch(GoodsTypeEnum gtype, Long gid, Long batchId, Long dstQuantity) {
        try {
            Long count = this.goodsBatchService.retrieveGoodsBatch(gtype, gid, batchId, dstQuantity);
            return DubboResult.successResult((Object)count);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodCouponRetrieveLogDto> queryRetrieveRet(Long id) {
        try {
            GoodCouponRetrieveLogDto ret = this.goodsCouponRetrieveLogService.find(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

