/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsDirectionalConfigDao;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.impl.RedisFilterCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class GoodsDirectionalConfigServiceImpl
implements GoodsDirectionalConfigService {
    @Autowired
    private GoodsDirectionalConfigDao goodsDirectionalConfigDao;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public GoodsDirectionalConfigEntity find(long id) {
        return this.goodsDirectionalConfigDao.selectById(id);
    }

    @Override
    public List<GoodsDirectionalConfigEntity> findByGoods(GoodsTypeEnum gtype, long goodsId) {
        return this.goodsDirectionalConfigDao.selectByGoods(gtype.getGtype(), goodsId);
    }

    @Override
    public GoodsDirectionalConfigEntity findByGoodsAndApp(GoodsTypeEnum gtype, long goodsId, long appId) {
        return this.goodsDirectionalConfigDao.selectByGoodsAndApp(gtype.getGtype(), goodsId, appId);
    }

    @Override
    public boolean add(GoodsDirectionalConfigEntity entity) {
        int num = this.goodsDirectionalConfigDao.insert(entity);
        boolean rs = num == 1;
        return rs;
    }

    @Override
    public boolean update(long id, Long stockId, Integer dayLimit, Integer minPrice) {
        int num = stockId == null ? this.goodsDirectionalConfigDao.update(id, dayLimit, minPrice) : this.goodsDirectionalConfigDao.updateMore(id, stockId, dayLimit, minPrice);
        GoodsDirectionalConfigEntity gdce = this.find(id);
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getDirectionalRedisKey(gdce.getGoodsId(), gdce.getAppId()));
        boolean rs = num == 1;
        return rs;
    }

    @Override
    public boolean remove(long id) {
        int num = this.goodsDirectionalConfigDao.delete(id);
        GoodsDirectionalConfigEntity gdce = this.find(id);
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getDirectionalRedisKey(gdce.getGoodsId(), gdce.getAppId()));
        boolean rs = num == 1;
        return rs;
    }

    @Override
    public GoodsDirectionalConfigEntity findSharedByGoods(GoodsTypeEnum gtype, long goodsId) {
        return this.goodsDirectionalConfigDao.selectByGoodsAndApp(gtype.getGtype(), goodsId, 0L);
    }

    @Override
    public GoodsDirectionalConfigEntity findByGoodsAndAppIncludeShared(GoodsTypeEnum gtype, long goodsId, long appId) {
        GoodsDirectionalConfigEntity e = this.findByGoodsAndApp(gtype, goodsId, appId);
        if (e == null) {
            e = this.findByGoodsAndApp(gtype, goodsId, 0L);
        }
        return e;
    }

    @Override
    public Map<String, GoodsDirectionalConfigEntity> findByGoodsAll(GoodsTypeEnum gtype, List<Long> goodss) {
        List<GoodsDirectionalConfigEntity> list = this.goodsDirectionalConfigDao.selectByGoodsAll(gtype, goodss);
        HashMap<String, GoodsDirectionalConfigEntity> maps = new HashMap<String, GoodsDirectionalConfigEntity>();
        for (GoodsDirectionalConfigEntity e : list) {
            maps.put(e.getAppId() + "-" + e.getGoodsId(), e);
        }
        return maps;
    }

    @Override
    public DayLimitConfig getDayLimit(GoodsTypeEnum gtype, long goodsId, long appId) {
        if (gtype != GoodsTypeEnum.PLATFORM) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
        long pcgId = goodsId;
        Integer dayLimit = null;
        GoodsDirectionalConfigEntity e = this.findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId);
        if (e != null) {
            if (e.getDayLimit() != null) {
                dayLimit = e.getDayLimit();
            }
        } else {
            e = this.findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId);
            if (e != null && e.getDayLimit() != null) {
                dayLimit = e.getDayLimit();
            }
        }
        if (dayLimit == null) {
            return null;
        }
        return new DayLimitConfig(dayLimit, e);
    }

    public static final class DayLimitConfig {
        private Integer dayLimit;
        private GoodsDirectionalConfigEntity config;

        public DayLimitConfig(Integer dayLimit, GoodsDirectionalConfigEntity config) {
            this.dayLimit = dayLimit;
            this.config = config;
        }

        public Integer getDayLimit() {
            return this.dayLimit;
        }

        public void setDayLimit(Integer dayLimit) {
            this.dayLimit = dayLimit;
        }

        public GoodsDirectionalConfigEntity getConfig() {
            return this.config;
        }

        public void setConfig(GoodsDirectionalConfigEntity config) {
            this.config = config;
        }
    }
}

