/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.RedisFilterCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pCGSellerGoodsService")
public class PCGSellerGoodsServiceImpl
implements PCGSellerGoodsService {
    @Autowired
    private PCGSellerGoodsDao pcgSellerGoodsDao;
    @Autowired
    private PCGSellerDao pcgSellerDao;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public Boolean addGoods2Seller(long sellerId, long pcgId, Integer payload) {
        int ret;
        if (payload == null || payload == 0) {
            payload = this.pcgSellerGoodsDao.selectMaxPayloadBySellerId(sellerId);
            payload = payload + 1;
        }
        if ((ret = this.pcgSellerGoodsDao.insertGoods2Seller(pcgId, sellerId, payload)) == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean removeGoodsFromSeller(long sellerId, long pcgId) {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getSellerGoodsRedisKey(String.valueOf(sellerId)));
        int ret = this.pcgSellerGoodsDao.deleteGoods2Seller(pcgId, sellerId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(value="pcg")
    public Boolean removeSeller(long sellerId) {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        redisFilterCache.clearFilterCache(redisFilterCache.getSellerGoodsRedisKey(String.valueOf(sellerId)));
        redisFilterCache.clearFilterCache(redisFilterCache.getSellerRedisKey());
        this.pcgSellerDao.delete(sellerId);
        this.pcgSellerGoodsDao.deleteSellerRelation(sellerId);
        return true;
    }

    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        List<PCGSellerGoodsEntity> pcgs = this.pcgSellerGoodsDao.selectByGoods(pcgId);
        for (PCGSellerGoodsEntity p : pcgs) {
            redisFilterCache.clearFilterCache(redisFilterCache.getCategoryGoodsRedisKey(String.valueOf(p.getSellerId())));
        }
        this.pcgSellerGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }

    @Override
    public Long addSeller(String name, String logo, Integer payload) {
        if (payload == null || payload == 0) {
            payload = this.pcgSellerDao.selectMaxPayloadBySeller();
            payload = payload + 1;
        }
        return this.pcgSellerDao.insert(name, logo, payload);
    }

    @Override
    public List<PCGSellerEntity> findAll() {
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        List<PCGSellerEntity> sellers = (List<PCGSellerEntity>)redisFilterCache.getFilterListCache(redisFilterCache.getSellerRedisKey(), PCGSellerEntity.class);
        if (sellers == null || sellers.isEmpty()) {
            sellers = this.pcgSellerDao.selectAll();
        }
        return sellers;
    }

    @Override
    public List<PCGSellerGoodsEntity> findAllGoodsBySeller(long sellerId) {
        return this.pcgSellerGoodsDao.selectBySeller(sellerId);
    }

    @Override
    public PCGSellerEntity findSeller(Long id) {
        return this.pcgSellerDao.select(id);
    }

    @Override
    public void sortSellerGoods(List<PCGSellerGoodsDto> list) {
        for (PCGSellerGoodsDto dto : list) {
            this.pcgSellerGoodsDao.updatePayload(dto.getSellerId(), dto.getPcgId(), dto.getPayload());
        }
    }

    @Override
    public void sortSellers(List<PCGSellerDto> sellers) {
        for (PCGSellerDto dto : sellers) {
            this.pcgSellerDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }

    @Override
    public void updateSellerPayload(Long id, int payload) {
        this.pcgSellerDao.updatePayload(id, payload);
    }

    @Override
    public void updateNamePayloadAndLogo(Long id, String name, String logo, Integer payload) {
        this.pcgSellerDao.updateNamePayloadAndLogo(id, name, logo, payload);
    }

    @Override
    public List<PCGSellerGoodsEntity> findAllGoodsBySellerIds(List<Long> sellerIds) {
        return this.pcgSellerDao.selectAllGoodsBySellerIds(sellerIds);
    }
}

