/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigBOImpl
implements PCGFilterConfigBO {
    private static Logger LOGGER = LoggerFactory.getLogger(PCGFilterConfigBOImpl.class);
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    protected RemoteAppService remoteAppService;
    @Autowired
    protected RemoteStockBackendService remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, 1);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    if (pcgId - filterGoodsId != 0L) continue;
                    ps.remove();
                }
            }
        }
        return pcgIds;
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = this.pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        this.pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (pcgIds != null && !pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() != pcgId.longValue()) continue;
            return p.getPayLoad();
        }
        return 0;
    }

    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId, Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads, Integer pageIndex, Integer pageSize) {
        ArrayList<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            DubboResult result;
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigBOImpl.isOpen(1, pce.getSwitches().intValue()) && !directionals.isEmpty()) {
                gdce1 = directionals.get(appId + "-" + pcgIdKey);
                gdce2 = directionals.get("0-" + pcgIdKey);
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, (Object)gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce2.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert((Object)gdce1, (Object)gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(Long.valueOf(0L));
                } else {
                    result = this.remoteStockBackendService.find(gdce1.getStockId().longValue());
                    if (result != null && result.isSuccess() && result.getResult() != null) {
                        gc.setStock((Long)result.getResult());
                    }
                }
            }
            psgd.setGoodsDirectionalConfigDto(gc);
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(Long.valueOf(pcgStock));
            goodsList.add(psgd);
        }
        return this.page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = this.pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        this.pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        pcgIds = this.checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize.intValue(), pageIndex.intValue());
        if (!pcgIds.isEmpty()) {
            page = this.findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    @Override
    public List<Long> checkBlack(List<Long> pcgIds, Long appId) {
        List<PCGCategoryEntity> cates = this.pCGFilterConfigService.findCategoryFilterList(appId);
        HashSet<Long> catSet = new HashSet<Long>();
        for (PCGCategoryEntity c : cates) {
            catSet.add(c.getId());
        }
        List<PCGSellerEntity> sellers = this.pCGFilterConfigService.findSellerFilterList(appId);
        HashSet<Long> sellerSet = new HashSet<Long>();
        for (PCGSellerEntity e : sellers) {
            sellerSet.add(e.getId());
        }
        Map<Long, List<PCGFilterConfigDto>> belongs = this.pCGFilterConfigService.findFilterCounponBelongs(catSet, sellerSet);
        List<PlatformCouponGoodsEntity> goodss = this.pCGFilterConfigService.findGoodsFilterList(appId);
        boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        block2: while (ps.hasNext()) {
            flag = true;
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                if (pcgId - goods.getPcgId() != 0L) continue;
                ps.remove();
                flag = false;
                break;
            }
            if (belongs == null || belongs.isEmpty()) continue;
            List<PCGFilterConfigDto> pcs = belongs.get(pcgId);
            if (!flag || pcs == null || pcs.isEmpty()) continue;
            for (PCGFilterConfigDto f : belongs.get(pcgId)) {
                if (f.getType() == 2) {
                    if (!catSet.contains(f.getTargetId())) continue;
                    ps.remove();
                    continue block2;
                }
                if (f.getType() != 3 || !sellerSet.contains(f.getTargetId())) continue;
                ps.remove();
                continue block2;
            }
        }
        return pcgIds;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        int totalPages;
        Page page = new Page(pageSize.intValue(), pageIndex.intValue());
        ArrayList<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int n = totalPages = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total && pageSize * (pageIndex + 1) != i; ++i) {
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize.intValue());
        page.setCurrent(pageIndex.intValue());
        return page;
    }

    @Override
    public List<PCGFloorDto> findPcgByAppId(Long appId, Integer size) {
        List<PCGCategorySellerGoodsDto> categoryGoodsList = this.pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
        List<PCGCategorySellerGoodsDto> sellerGoodsList = this.pCGFilterConfigService.selectPCGSellerGoodsList(appId);
        sellerGoodsList.removeAll(categoryGoodsList);
        sellerGoodsList.addAll(categoryGoodsList);
        Collections.sort(sellerGoodsList);
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            if (pcgIds.size() >= size) break;
            pcgIds.add(it.getPcgId());
        }
        sellerGoodsList = sellerGoodsList.subList(0, pcgIds.size());
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        ArrayList<PCGFloorDto> goodsList = new ArrayList<PCGFloorDto>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            PlatformCouponGoodsEntity pce = pcgs.get(it.getPcgId());
            if (!this.canShow(directionals, pce, appId)) continue;
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            psgd.setMinPrice(this.getMinPrice(directionals, pce, appId));
            psgd.setPayLoad(it.getPayLoad());
            this.setGoodsBatch(psgd, it.getPcgId());
            goodsList.add(psgd);
        }
        return goodsList;
    }

    @Deprecated
    public List<PCGFloorDto> findPcgByIds(final List<Long> pcgIds, Long appId, Long consumerId, Long appRate, Long consumerCredits) {
        ArrayList<PCGFloorDto> goodsList = new ArrayList<PCGFloorDto>();
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = this.platformCouponGoodsService.findByIds(pcgIds);
        for (Long it : pcgs.keySet()) {
            PlatformCouponGoodsEntity pce = pcgs.get(it);
            if (!this.canShow(directionals, pce, appId)) continue;
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert((Object)pce, (Object)psgd);
            psgd.setStock(this.getStock(directionals, pce, appId));
            psgd.setMinPrice(this.getMinPrice(directionals, pce, appId));
            psgd.setPayLoad(Integer.valueOf(0));
            this.setGoodsBatch(psgd, it);
            goodsList.add(psgd);
        }
        Collections.sort(goodsList, new Comparator<PCGFloorDto>(){

            @Override
            public int compare(PCGFloorDto o1, PCGFloorDto o2) {
                if (pcgIds.indexOf(o1.getPcgId()) > pcgIds.indexOf(o2.getPcgId())) {
                    return 1;
                }
                if (pcgIds.indexOf(o1.getPcgId()) < pcgIds.indexOf(o2.getPcgId())) {
                    return -1;
                }
                return 0;
            }
        });
        return goodsList;
    }

    private void setGoodsBatch(PCGFloorDto psgd, Long pcgId) {
        List<GoodsBatchDto> goodsBatchs = this.goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pcgId);
        String currentTime = this.sdf2.format(new Date());
        for (GoodsBatchDto goodsBatch : goodsBatchs) {
            if (goodsBatch.getStatus() == null || goodsBatch.getStatus() == 3 || goodsBatch.getStatus() == 4 || goodsBatch.getStock() <= 0L || Integer.parseInt(this.sdf2.format(goodsBatch.getEndDay())) < Integer.parseInt(currentTime)) continue;
            psgd.setStartDate(this.sdf.format(goodsBatch.getStartDay()));
            psgd.setEndDate(this.sdf.format(goodsBatch.getEndDay()));
            break;
        }
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank((String)psgd.getEndDate())) {
            psgd.setStartDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            psgd.setEndDate(this.sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
        }
    }

    private int getExchangeType(PCGFloorDto psgd, Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Map<Long, Integer> exchangeCountMap, Long appId, Long appRate, Long consumerCredits) {
        Long credits;
        Integer consumerExchangeCount = exchangeCountMap.get(entity.getPcgId());
        if (consumerExchangeCount == null) {
            consumerExchangeCount = 0;
        }
        if ((credits = this.getCredits(psgd.getMinPrice(), appRate)) == null) {
            LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
            return 3;
        }
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        Integer dayLimit = null;
        if (directionalConfig != null) {
            dayLimit = directionalConfig.getDayLimit();
        }
        int result = 0;
        if (entity.getLimitPerConsumer() != null && entity.getLimitPerConsumer() - consumerExchangeCount <= 0) {
            result = 1;
            psgd.setPayLoad(Integer.valueOf(psgd.getPayLoad() == null ? 0 : psgd.getPayLoad() + 400));
        } else if (consumerCredits <= credits) {
            result = 2;
        } else if (psgd.getStock() == 0L || !this.checkDayLimit(dayLimit, consumerExchangeCount)) {
            result = 3;
            psgd.setPayLoad(Integer.valueOf(psgd.getPayLoad() == null ? 0 : psgd.getPayLoad() + 300));
        } else {
            result = 4;
        }
        return result;
    }

    private boolean checkDayLimit(Integer dayLimit, Integer consumerExchangeCount) {
        return dayLimit == null || dayLimit - consumerExchangeCount > 0;
    }

    private boolean canShow(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        Object gdce1 = null;
        Object gdce2 = null;
        if (1 != entity.getPcgStatus() || entity.getDeleted().booleanValue()) {
            return false;
        }
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return true;
        }
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        return directionalConfig != null;
    }

    private GoodsDirectionalConfigEntity getGoodsDirectionalConfig(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return null;
        }
        if (directionals.isEmpty()) {
            return null;
        }
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        gdce1 = directionals.get(appId + "-" + entity.getPcgId());
        gdce2 = directionals.get("0-" + entity.getPcgId());
        if (gdce1 == null && gdce2 == null) {
            return null;
        }
        if (gdce1 != null) {
            return gdce1;
        }
        return gdce2;
    }

    private Long getCredits(Integer duibaPrice, Long creditsRate) {
        if (duibaPrice == null || creditsRate == null) {
            return null;
        }
        long credits = (long)Math.ceil((double)((long)duibaPrice.intValue() * creditsRate) / 100.0);
        if (credits < 1L) {
            credits = 1L;
        }
        return credits;
    }

    private Integer getMinPrice(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return entity.getMinPrice();
        }
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return entity.getMinPrice();
        }
        return directionalConfig.getMinPrice() != null ? directionalConfig.getMinPrice() : entity.getMinPrice();
    }

    private Long getStock(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, entity.getPcgId());
        if (pcgStock == 0L) {
            return 0L;
        }
        if (!PCGFilterConfigBOImpl.isOpen(1, entity.getSwitches().intValue())) {
            return pcgStock;
        }
        long preStock = 0L;
        GoodsDirectionalConfigEntity directionalConfig = this.getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return 0L;
        }
        DubboResult result = this.remoteStockBackendService.find(directionalConfig.getStockId().longValue());
        if (result != null && result.isSuccess() && result.getResult() != null) {
            preStock = (Long)result.getResult();
        }
        return Math.min(pcgStock, preStock);
    }

    public static class PCGIdAndPayLoad {
        private Long pagId;
        private Integer payLoad;

        public PCGIdAndPayLoad() {
        }

        public PCGIdAndPayLoad(Long pcgId, Integer payLoad) {
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }

        public Long getPagId() {
            return this.pagId;
        }

        public Integer getPayLoad() {
            return this.payLoad;
        }
    }
}

