/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.pcg.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.SwitchUtils;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsDirectionalConfigServiceImpl;
import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.goods.center.biz.util.PcgCreditsCalculteTool;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pCGUtilBO")
public class PCGUtilBOImpl
implements PCGUtilBO {
    private static Logger log = LoggerFactory.getLogger(PCGUtilBOImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private PCGFilterConfigService pcgFilterConfigService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;
    @Autowired
    private PcgDirectionalSalesVolumeService pcgDirectionalSalesVolumeService;

    @Override
    public boolean canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) throws Exception {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (pcg == null) {
            log.error("canTakePlatformCouponGoods pcgId=" + pcgId + ", but query result is null");
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (pcg.getDeleted().booleanValue()) {
            log.error("canTakePlatformCouponGoods pcgId=" + pcgId + ", but query result is deleted");
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (pcg.getPcgStatus() == 0) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (this.isInBlack(pcg, appId)) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (!this.checkStockEnough(pcg, appId, consumerId)) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        return true;
    }

    @Override
    public long getStockInApp(long pcgId, long appId) {
        Object config;
        Long stock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pcgId);
        if (stock == null || stock <= 0L) {
            return 0L;
        }
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (SwitchUtils.enable((int)pcg.getSwitches().intValue(), (int)1)) {
            config = this.goodsDirectionalConfigService.findByGoodsAndAppIncludeShared(GoodsTypeEnum.PLATFORM, pcgId, appId);
            if (config == null) {
                return 0L;
            }
            if (((GoodsDirectionalConfigEntity)config).getStockId() == null) {
                return 0L;
            }
            DubboResult stockRet = this.remoteStockService.find(((GoodsDirectionalConfigEntity)config).getStockId().longValue());
            if (!stockRet.isSuccess() || (Long)stockRet.getResult() <= 0L) {
                return 0L;
            }
            if (stock > (Long)stockRet.getResult()) {
                stock = (Long)stockRet.getResult();
            }
        }
        if ((config = this.goodsDirectionalConfigService.getDayLimit(GoodsTypeEnum.PLATFORM, pcgId, appId)) != null) {
            if (((GoodsDirectionalConfigServiceImpl.DayLimitConfig)config).getDayLimit() <= 0) {
                return 0L;
            }
            Long sales = this.pcgDirectionalSalesVolumeService.findSaleCountToday(pcgId, ((GoodsDirectionalConfigServiceImpl.DayLimitConfig)config).getConfig().getId());
            if (sales >= (long)((GoodsDirectionalConfigServiceImpl.DayLimitConfig)config).getDayLimit().intValue()) {
                return 0L;
            }
            long remaining = (long)((GoodsDirectionalConfigServiceImpl.DayLimitConfig)config).getDayLimit().intValue() - sales;
            if (stock > remaining) {
                stock = remaining;
            }
        }
        return stock;
    }

    @Override
    public boolean checkStockEnough(long pcgId, long appId, long consumerId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        return this.checkStockEnough(pcg, appId, consumerId);
    }

    public boolean checkStockEnough(PlatformCouponGoodsEntity pcg, long appId, long consumerId) {
        long pcgId = pcg.getPcgId();
        long stock = this.getStockInApp(pcg.getPcgId(), appId);
        if (stock <= 0L) {
            return false;
        }
        if (pcg.getLimitPerConsumer() != null) {
            int limit = pcg.getLimitPerConsumer();
            int count = this.goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
            if (count >= limit) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isInBlack(PlatformCouponGoodsEntity pcg, long appId) {
        List<PlatformCouponGoodsEntity> goods = this.pcgFilterConfigService.findGoodsFilterList(appId);
        HashSet<Long> blackGoodsIds = new HashSet<Long>();
        for (PlatformCouponGoodsEntity e : goods) {
            blackGoodsIds.add(e.getPcgId());
        }
        if (blackGoodsIds.contains(pcg.getPcgId())) {
            return true;
        }
        List<PCGFilterConfigDto> belongs = this.pcgFilterConfigService.findCounponBelong(pcg.getPcgId());
        if (belongs.isEmpty()) {
            return false;
        }
        List<PCGCategoryEntity> cates = this.pcgFilterConfigService.findCategoryFilterList(appId);
        List<PCGSellerEntity> sellers = this.pcgFilterConfigService.findSellerFilterList(appId);
        HashSet<Long> catSet = new HashSet<Long>();
        for (PCGCategoryEntity c : cates) {
            catSet.add(c.getId());
        }
        HashSet<Long> sellerSet = new HashSet<Long>();
        for (PCGSellerEntity e : sellers) {
            sellerSet.add(e.getId());
        }
        for (PCGFilterConfigDto f : belongs) {
            if (!(f.getType() == 2 ? catSet.contains(f.getTargetId()) : f.getType() == 3 && sellerSet.contains(f.getTargetId()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId) {
        GoodsDirectionalConfigEntity e;
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (SwitchUtils.enable((int)pcg.getSwitches().intValue(), (int)1) && ((e = this.goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId)) == null ? (e = this.goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId)) != null && e.getMinPrice() != null : e.getMinPrice() != null)) {
            return PcgCreditsCalculteTool.getCredits(e.getMinPrice().intValue(), this.remoteAppService.find(Long.valueOf(appId)).getCreditsRate().intValue());
        }
        Long credits = PcgCreditsCalculteTool.getCredits(pcg.getMinPrice().intValue(), this.remoteAppService.find(Long.valueOf(appId)).getCreditsRate().intValue());
        return credits;
    }
}

